/*                                                                             
 * Copyright 2004,2005 The Apache Software Foundation.                         
 *                                                                             
 * Licensed under the Apache License, Version 2.0 (the "License");             
 * you may not use this file except in compliance with the License.            
 * You may obtain a copy of the License at                                     
 *                                                                             
 *      http://www.apache.org/licenses/LICENSE-2.0                             
 *                                                                             
 * Unless required by applicable law or agreed to in writing, software         
 * distributed under the License is distributed on an "AS IS" BASIS,           
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.    
 * See the License for the specific language governing permissions and         
 * limitations under the License.                                              
 */
package org.wso2.admin.service;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.Constants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.MessageContext;
import org.wso2.wsas.AbstractTestCase;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.TestConstants;
import org.wso2.wsas.util.ServerUtils;

import javax.xml.namespace.QName;

/**
 *
 */
public class ServerAdminT extends AbstractTestCase {

    protected void setUp() throws Exception {
        System.setProperty(ServerConstants.DERBY_HOME, "conf");
        System.setProperty(ServerConstants.WSO2WSAS_ADMIN_PASSWORD, "abc");
        System.setProperty(ServerConstants.WSO2WSAS_HOME, "target/tomcat_test");
        System.setProperty(ServerConstants.WSO2WSAS_SERVER_XML,
                           "target/tomcat_test/conf/server.xml");

        ServerUtils serverUtils = new ServerUtils();
        serverUtils.startServer();
    }

    public void testSuspendConnector() throws Exception {
        EndpointReference versionEPR =
                new EndpointReference("http://127.0.0.1" + ":"
                                      + (TestConstants.TESTING_PORT)
                                      + "/" + ServerConstants.SERVICE_PATH +
                                      "/version/getVersion");
        EndpointReference serverAdminEPR =
                new EndpointReference("http://127.0.0.1" + ":"
                                      + (TestConstants.TESTING_PORT)
                                      + "/" + ServerConstants.SERVICE_PATH +
                                      "/ServerAdmin/enterMaintenance");

        testConnect(versionEPR);

        removeProperties();

        {
            ServiceClient serviceAdminSender = new ServiceClient();
            Options options = new Options();
            options.setTo(serverAdminEPR);
            options.setTransportInProtocol(Constants.TRANSPORT_HTTP);
            options.setUseSeparateListener(false);
            serviceAdminSender.setOptions(options);
            options.setAction("enterMaintenance");

            OMFactory fac = OMAbstractFactory.getOMFactory();
            QName qName =
                    new QName("http://service.admin.wsas.wso2.org", "enterMaintenanceRequest");

            OMNamespace ns =
                    fac.createOMNamespace(qName.getNamespaceURI(), "ns");
            OMElement omElement = serviceAdminSender.sendReceive(fac.createOMElement(qName.getLocalPart(), ns));
            System.out.println(omElement);
        }


        AxisCallback callback = new AxisCallback() {

            public void onMessage(MessageContext messageContext) {
                System.out.println("Response received");

            }

            public void onFault(MessageContext messageContext) {
                System.out.println("Fault occurred");
            }

            public void onError(Exception e) {
                System.out.println("Errro occurred " + e);
            }

            public void onComplete() {
                System.out.println("Completed");
            }
        };
        ServiceClient versionSender = new ServiceClient();
        Options options = new Options();
        options.setTo(versionEPR);
        options.setTransportInProtocol(Constants.TRANSPORT_HTTP);
        options.setUseSeparateListener(false);
        versionSender.setOptions(options);
        options.setAction("getVersion");
        versionSender.sendReceiveNonBlocking(getTestPayload(), callback);
    }
}
