/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2;

import org.wso2.wsas.AbstractTestCase;
import org.wso2.wsas.TestConstants;
import org.wso2.wsas.ServerConstants;
import org.wso2.utils.NetworkUtils;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.OMElement;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.HttpClient;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import java.io.ByteArrayInputStream;
/*
 * 
 */

public class LoadT extends AbstractTestCase {

    public void testLoadEchoInt() throws Exception {

        EndpointReference epr =
                new EndpointReference("http://" + NetworkUtils.getLocalHostname() + ":" +
                                      TestConstants.TESTING_PORT +
                                      "/" + ServerConstants.SERVICE_PATH +
                                      "/echo");

        testConnect(epr);

        ConfigurationContext cc = ConfigurationContextFactory.createDefaultConfigurationContext();


        ServiceClient sc = new ServiceClient(null,null);

        Options options = new Options();
        options.setTo(epr);
        options.setAction("urn:echoInt");
        options.setCallTransportCleanup(true);

        sc.setOptions(options);

        String payload = "<p:echoInt xmlns:p=\"http://echo.services.wsas.wso2.org\"><in>22</in></p:echoInt>";
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance()
                .createXMLStreamReader(new ByteArrayInputStream(payload.getBytes()));

        StAXOMBuilder builder = new StAXOMBuilder(xmlStreamReader);

        OMElement ele = builder.getDocumentElement();

        for (int i = 0; i < 1000; i++) {
            long start = System.currentTimeMillis();
            OMElement omElement = sc.sendReceive(ele);

            assertNotNull(omElement);

            long end = System.currentTimeMillis();

            System.out.println("#### Number "+i+ "  Response received #### " + (end-start));
        }




    }
}
