/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.util;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import java.io.*;

public class XMLUtils {

    /**
     * This will create an OMElement out of the XML fragment provided.
     *
     * @param fileName
     * @return
     * @throws FileNotFoundException
     * @throws XMLStreamException
     */
    public static OMElement getDocumentElement(String fileName)
            throws FileNotFoundException, XMLStreamException {
        return new StAXOMBuilder(fileName).getDocumentElement();
    }

    /**
     * This helps to create a DOM document from a given input stream. We need use DOM as we use
     * XMLUnit to compare two xmls and XMLUnit requires xmls to be input as DOM documents.
     *
     * @param is
     * @return
     * @throws ParserConfigurationException
     * @throws SAXException
     * @throws IOException
     */
    public static Document newDocument(InputStream is)
            throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(is);
    }

    /**
     * @param xml
     * @return
     * @throws ParserConfigurationException
     * @throws SAXException
     * @throws IOException
     * @see XMLUtils#newDocument(java.io.InputStream)
     */
    public static Document newDocument(String xml)
            throws ParserConfigurationException, SAXException, IOException {
        return newDocument(new ByteArrayInputStream(xml.getBytes()));
    }

    /**
     * @param file
     * @return
     * @throws ParserConfigurationException
     * @throws SAXException
     * @throws IOException
     * @see XMLUtils#newDocument(java.io.InputStream)
     */
    public static Document newDocument(File file)
            throws ParserConfigurationException, SAXException, IOException {
        return newDocument(new FileInputStream(file));
    }

}
