/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.util;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.WSDL2Constants;
import org.apache.axis2.receivers.RawXMLINOutMessageReceiver;
import org.wso2.utils.ServerException;
import org.wso2.wsas.Main;

import javax.xml.namespace.QName;
import java.util.Map;
import java.util.HashMap;

public class ServerUtils {
    private Main main;

    /**
     * This is a convenience method extracted from Axis2 to deploy a service
     *
     * @param configurationContext
     * @param service
     * @throws AxisFault
     */
    public static void deployService(ConfigurationContext configurationContext,
                                     AxisService service) throws AxisFault {
        configurationContext.getAxisConfiguration().addService(service);
    }

    /**
     * This will deploy a service which will use the RawXMLInOutMessageReceiver.
     *
     * @param configurationContext
     * @param serviceImplClass
     * @throws AxisFault
     */
    public void deployServiceUsingInOutMsgReceiver(
            ConfigurationContext configurationContext, String serviceImplClass)
            throws AxisFault {
        Map mrMap = new HashMap();
        mrMap.put(WSDL2Constants.MEP_URI_IN_OUT, new RawXMLINOutMessageReceiver());
        deployService(configurationContext,
                      serviceImplClass,
                      mrMap);
    }

    /**
     * This is the easiest and much flexible way of deploying a service in Axis2.
     * Will be useful for tests.
     *
     * @param configurationContext
     * @param serviceImplClass
     * @throws AxisFault
     */
    public static void deployService(ConfigurationContext configurationContext,
                                     String serviceImplClass,
                                     Map messageReceiverClassesMap)
            throws AxisFault {
        AxisService simpleService = deployService(configurationContext,
                                                  serviceImplClass,
                                                  messageReceiverClassesMap,
                                                  null, null);
        configurationContext.getAxisConfiguration().addService(simpleService);
    }

    public static AxisService deployService(ConfigurationContext configurationContext,
                                            String serviceImplClass,
                                            Map messageReceiverClassMap,
                                            String targetNameSpace,
                                            String schemaNamespace) throws AxisFault {
        AxisService axisService = AxisService.createService(
                serviceImplClass,
                configurationContext.getAxisConfiguration(),
                messageReceiverClassMap,
                targetNameSpace,
                schemaNamespace,
                Thread.currentThread().getContextClassLoader());
        configurationContext.getAxisConfiguration().addService(axisService);
        return axisService;
    }

    public void startServer() {
        initializeTestingServer();
    }

    /*
    Initializing WSO2 WSAS testing server
    */
    private void initializeTestingServer() {
        main = new Main();
        main.startServer();
    }

    public void startServer(String serverConfigLocation) {
        initializeTestingServer();
    }

    public void shutdown() throws ServerException {
        if (main != null) {
            main.shutdown();
        }
    }

    public Main getWSASInstance() {
        return main;
    }

    public synchronized void undeployService(ConfigurationContext configCtx,
                                             QName service) throws AxisFault {
        configCtx.getAxisConfiguration().removeService(service.getLocalPart());
    }
}
