/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.util;

import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.handlers.AbstractHandler;

public class MessageExposeHandler extends AbstractHandler {

    private static final long serialVersionUID = 3774384706309819661L;

    private SOAPEnvelope soapEnvelope;

    public InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        soapEnvelope = msgContext.getEnvelope();
        return InvocationResponse.CONTINUE;
    }

    public SOAPEnvelope getSoapEnvelope() {
        return soapEnvelope;
    }


}
