/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.util;

import junit.framework.TestCase;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.wso2.wsas.ServerConstants;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;

/**
 *
 */
public class MIMEType2FileExtensionMapTest extends TestCase {

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty(ServerConstants.DERBY_HOME, "conf");
    }

    public void testGetMimeType() throws FileNotFoundException, XMLStreamException {
        String mappingFileName = "conf/mime-mappings.xml";
        OMElement doc = new StAXOMBuilder(mappingFileName).getDocumentElement();
        for (Iterator childIter = doc.getChildElements(); childIter.hasNext();) {
            OMElement mappingEle = (OMElement) childIter.next();
            String ext = mappingEle.getFirstChildWithName(new QName("Extension")).getText();
            String mimeType = mappingEle.getFirstChildWithName(new QName("MimeType")).getText();
            assertEquals(mimeType,
                         MIMEType2FileExtensionMap.getInstance().getMIMEType(new File("test." + ext)));
        }
    }
}
