/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.util;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Echo {

    private static Log log = LogFactory.getLog(Echo.class);

    public Echo() {
    }

    public void echoVoid() {
        log.info("echo Service Called");
    }


    public OMElement echoOMElement(OMElement omEle) {
        System.out.println("omEle = " + omEle);
        omEle.setLocalName(omEle.getLocalName() + "Response");
        return omEle;
    }

    public String echoString(String in) {
        return in;
    }

    public int echoInt(int in) {
        return in;
    }

    public OMElement echoMTOMtoBase64(OMElement omEle) {
        OMText omText = (OMText) omEle.getFirstOMChild();
        omText.setOptimize(false);
        return omEle;
    }

}
