/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.security;

import junit.framework.TestCase;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.handler.WSHandlerConstants;
import org.wso2.utils.ServerException;
import org.wso2.wsas.ServerConstants;

import javax.security.auth.callback.CallbackHandler;

public class WSS4JUtilTest extends TestCase {

    public WSS4JUtilTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty(ServerConstants.DERBY_HOME, "conf");
    }

    /**
     * This is to test the i18n of the error message
     */
    public void testGetUsernameTokenPrincipal() {
        MessageContext ctx = new MessageContext();
        try {
            WSS4JUtil.getUsernameTokenPrincipal(ctx);
            fail();
        } catch (ServerException e) {
            assertEquals("Incorrect error message",
                         "No security results available in the message context", e.getMessage());
        }
    }

    /**
     *
     *
     */
    public void testGetClientUsernameTokenHandler() {
        String password = "password";
        Parameter param = WSS4JUtil.getClientUsernameTokenHandler(password);
        assertNotNull("Parameter missing", param);
        assertEquals("Parameter name mismatch", WSHandlerConstants.PW_CALLBACK_REF, param.getName());
        WSPasswordCallback passwordCallback =
                new WSPasswordCallback("anyuser",
                                       WSPasswordCallback.USERNAME_TOKEN);
        WSPasswordCallback[] pwcb = {passwordCallback};
        try {
            CallbackHandler handler = (CallbackHandler) param.getValue();
            handler.handle(pwcb);
        } catch (Throwable e) {
            fail(e.getMessage());
        }
        assertEquals("Password mismatch", password, passwordCallback.getPassword());
    }

}
