/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.security;

import junit.framework.TestCase;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.security.CryptoException;
import org.wso2.utils.security.CryptoUtil;
import org.wso2.wsas.ServerConstants;

public class CryptoUtilTest extends TestCase {

    public CryptoUtilTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty(ServerConstants.DERBY_HOME, "conf");
    }

    public void testEncryptDecrypt() {
        String plainText = "passphrase";
        try {
            ServerConfiguration config = ServerConfiguration.getInstance();
            CryptoUtil cryptoUtil =
                    new CryptoUtil(config.getFirstProperty("Security.KeyStore.Location"),
                                   config.getFirstProperty("Security.KeyStore.Password"),
                                   config.getFirstProperty("Security.KeyStore.KeyAlias"),
                                   config.getFirstProperty("Security.KeyStore.KeyPassword"),
                                   config.getFirstProperty("Security.KeyStore.Type"));
            byte[] cipherTextBytes = cryptoUtil.encrypt(plainText.getBytes());
            byte[] plainTextBytes = cryptoUtil.decrypt(cipherTextBytes);
            assertEquals("Decrypted value is incorrect", plainText, new String(plainTextBytes));
        } catch (CryptoException e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
}
