/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence;

import org.wso2.wsas.persistence.dataobject.ServiceUserRoleDO;
import org.wso2.wsas.persistence.exception.DuplicateEntityException;

/**
 *
 */
public class UserRoleDAOTest extends AbstractDAOTestCase {
    public void testGetUserRoles() {
        int oldNumOfUserRoles = userRoleDAO.getUserRoles().length;
        for (int i = 0; i < 2; i++) {
            ServiceUserRoleDO role = new ServiceUserRoleDO();
            role.setRole("Role" + i + ":" + System.currentTimeMillis());
            try {
                userRoleDAO.create(role);
            } catch (DuplicateEntityException e) {
                fail("Unexpected Exception " + e);
            }
        }
        ServiceUserRoleDO[] userRoles = userRoleDAO.getUserRoles();
        assertEquals(oldNumOfUserRoles + 2, userRoles.length);
        for (int i = 0; i < userRoles.length; i++) {
            ServiceUserRoleDO userRole = userRoles[i];
            assertNotNull(userRole.getRole());
        }
    }

    public void testGetRole() {
        ServiceUserRoleDO role = new ServiceUserRoleDO();
        String roleStr = "Role" + System.currentTimeMillis();
        role.setRole(roleStr);
        try {
            userRoleDAO.create(role);
        } catch (DuplicateEntityException e) {
            fail("Unexpected Exception " + e);
        }
        ServiceUserRoleDO serviceUserRole = userRoleDAO.getUserRole(roleStr);
        assertNotNull(serviceUserRole);
        assertEquals(roleStr, serviceUserRole.getRole());
    }
}
