/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence;

import org.wso2.wsas.persistence.dataobject.ServiceUserDO;
import org.wso2.wsas.persistence.dataobject.ServiceUserRoleDO;
import org.wso2.wsas.persistence.exception.DuplicateEntityException;

/**
 *
 */
public class UserDAOTest extends AbstractDAOTestCase {
    public void testGetAllUsers() {
        int oldNumOfUsers = userDAO.getUsers().length;
        for (int i = 0; i < 2; i++) {
            ServiceUserDO user = new ServiceUserDO();
            ServiceUserRoleDO userRole = new ServiceUserRoleDO();
            userRole.setRole("Role" + i + System.currentTimeMillis());
            try {
                userRoleDAO.create(userRole);
            } catch (DuplicateEntityException e) {
                fail("Unexpected Exception " + e);
            }
//            user.setServiceUserRole(userRole);
            user.setUsername("user" + i + System.currentTimeMillis());
            user.setPassword("password");
            try {
                userDAO.create(user);
            } catch (DuplicateEntityException e) {
                fail("Unexpected Exception " + e);
            }
        }
        ServiceUserDO[] users = userDAO.getUsers();
        assertEquals(oldNumOfUsers + 2, users.length);
        for (int i = 0; i < users.length; i++) {
            ServiceUserDO user = users[i];
            assertNotNull(user.getPassword());
            assertNotNull(user.getUsername());
        }
    }

    public void testDeleteUser() {
        ServiceUserDO user = new ServiceUserDO();
        ServiceUserRoleDO userRole = new ServiceUserRoleDO();
        userRole.setRole("Role" + System.currentTimeMillis());
        try {
            userRoleDAO.create(userRole);
        } catch (DuplicateEntityException e) {
            fail("Unexpected Exception " + e);
        }
//        user.setServiceUserRole(userRole);
        String username = "user" + System.currentTimeMillis();
        user.setUsername(username);
        user.setPassword("password");
        try {
            userDAO.create(user);
        } catch (DuplicateEntityException e) {
            fail("Unexpected Exception " + e);
        }
        assertNotNull(userDAO.getUser(username));
        userDAO.deleteUser(username);
        assertNull(userDAO.getUser(username));
    }

    public void testUpdateUser() {
        ServiceUserDO user = new ServiceUserDO();
        ServiceUserRoleDO userRole = new ServiceUserRoleDO();
        userRole.setRole("Role" + System.currentTimeMillis());
        try {
            userRoleDAO.create(userRole);
        } catch (DuplicateEntityException e) {
            fail("Unexpected Exception " + e);
        }
//        user.setServiceUserRole(userRole);
        String username = "user" + System.currentTimeMillis();
        user.setUsername(username);
        user.setPassword("password");
        try {
            userDAO.create(user);
        } catch (DuplicateEntityException e) {
            fail("Unexpected Exception " + e);
        }

        user = userDAO.getUser(username);
        assertEquals("password", user.getPassword());
        user.setPassword("newPassword");
        userDAO.update(user);
        user = userDAO.getUser(username);
        assertEquals("newPassword", user.getPassword());
    }

    public void testRoles() throws Exception {
        ServiceUserDO user = new ServiceUserDO();
        String username = "user" + System.currentTimeMillis();
        user.setUsername(username);
        user.setPassword("password");

        try {
            userDAO.create(user);
        } catch (DuplicateEntityException e) {
            fail("Unexpected Exception " + e);
        }

        for (int i = 0; i < 2; i++) {
            ServiceUserRoleDO role = new ServiceUserRoleDO();
            role.setRole("MultiRole  :" + i);
            try {
                userRoleDAO.create(role);
            } catch (DuplicateEntityException e) {
                fail("Unexpected Exception " + e);
            }

            userDAO.addRole(username, role);

        }

        ServiceUserDO serviceUserDO = userDAO.getUser(username);
        assertNotNull(serviceUserDO);

        ServiceUserRoleDO[] serviceUserRoleDOs = userDAO.getRoles(username);
        assertEquals(2, serviceUserRoleDOs.length);

        /*
        // TODO as Array output is not ordered, assertion needed to be fixed in anotherway. 
        for (int i = 0; i < serviceUserRoleDOs.length; i++) {
            ServiceUserRoleDO role = serviceUserRoleDOs[i];
            assertEquals("MultiRole  :" + i, role.getRole());
        }*/


    }

    public void testDeleteRole() throws Exception {
        ServiceUserDO user = new ServiceUserDO();
        String username = "user" + System.currentTimeMillis();
        user.setUsername(username);
        user.setPassword("password");

        try {
            userDAO.create(user);
        } catch (DuplicateEntityException e) {
            fail("Unexpected Exception " + e);
        }

        for (int i = 0; i < 2; i++) {
            ServiceUserRoleDO role = new ServiceUserRoleDO();
            role.setRole("MultiRoleX  :" + i);
            try {
                userRoleDAO.create(role);
            } catch (DuplicateEntityException e) {
                e.printStackTrace();
                fail("Unexpected Exception " + e);
            }

            userDAO.addRole(username, role);

        }

        ServiceUserDO serviceUserDO = userDAO.getUser(username);
        assertNotNull(serviceUserDO);

        ServiceUserRoleDO[] serviceUserRoleDOs = userDAO.getRoles(username);
        assertEquals(2, serviceUserRoleDOs.length);

        userDAO.deleteRoleFromUser(username, "MultiRoleX  :1");
        serviceUserRoleDOs = userDAO.getRoles(username);
        assertEquals(1, serviceUserRoleDOs.length);
        for (int i = 0; i < serviceUserRoleDOs.length; i++) {
            ServiceUserRoleDO role = serviceUserRoleDOs[i];
            assertEquals("MultiRoleX  :0", role.getRole());
        }

    }

    public void testDeleteUserWithRole() throws Exception {
        ServiceUserDO user = new ServiceUserDO();
        String username = "user" + System.currentTimeMillis();
        user.setUsername(username);
        user.setPassword("password");

        try {
            userDAO.create(user);
        } catch (DuplicateEntityException e) {
            fail("Unexpected Exception " + e);
        }

        for (int i = 0; i < 2; i++) {
            ServiceUserRoleDO role = new ServiceUserRoleDO();
            role.setRole("MultiRoleY :" + i);
            try {
                userRoleDAO.create(role);
            } catch (DuplicateEntityException e) {
                e.printStackTrace();
                fail("Unexpected Exception " + e);
            }

            userDAO.addRole(username, role);

        }

        ServiceUserDO serviceUserDO = userDAO.getUser(username);
        assertNotNull(serviceUserDO);

        ServiceUserRoleDO[] serviceUserRoleDOs = userDAO.getRoles(username);
        assertEquals(2, serviceUserRoleDOs.length);

        userDAO.deleteUser(username);
        assertNull(userDAO.getUser(username));
    }
}
