/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence;

import org.apache.axis2.description.AxisService;
import org.wso2.wsas.persistence.dataobject.*;
import org.wso2.wsas.persistence.exception.DuplicateEntityException;
import org.wso2.wsas.persistence.exception.ServicePolicyNotFoundException;

/**
 *
 */
public class ServiceDAOTest extends AbstractDAOTestCase {

    public void testAddOperations() {
        String serviceId = "TestAddOperationsService";
        String version = String.valueOf(System.currentTimeMillis());
        createTestService(serviceId, version);

        ServiceDO service = serviceDAO.getService(serviceId, version);
        assertNotNull(service);
        for (int i = 0; i < 2; i++) {
            OperationDO op = new OperationDO();
            op.setName("op" + i);
            serviceDAO.addOperation(serviceId, version, op);
        }
        OperationDO[] ops = serviceDAO.getOperations(serviceId, version);
        assertEquals(2, ops.length);
        for (int i = 0; i < ops.length; i++) {
            OperationDO op = ops[i];
            assertTrue(op.getName().indexOf("op") == 0);
        }
        for (int i = 0; i < 2; i++) {
            OperationDO op = new OperationDO();
            op.setName("opNew" + i);
            serviceDAO.addOperation(serviceId, version, op);
        }
        ops = serviceDAO.getOperations(serviceId, version);
        assertEquals(4, ops.length);
        for (int i = 0; i < ops.length; i++) {
            OperationDO op = ops[i];
            assertTrue(op.getName().indexOf("op") == 0);
        }
        assertNotNull(service);
        assertEquals(serviceId, service.getServiceIdentifierDO().getServiceId());
        assertEquals(version, service.getServiceIdentifierDO().getVersion());
    }

    public void testAddUsers() {
        String serviceId = "TestAddUsersService";
        String version = String.valueOf(System.currentTimeMillis());
        createTestService(serviceId, version);

        ServiceDO service = serviceDAO.getService(serviceId, version);
        assertNotNull(service);
        for (int i = 0; i < 2; i++) {
            ServiceUserDO user = new ServiceUserDO();
            ServiceUserRoleDO userRole = new ServiceUserRoleDO();
            userRole.setRole("Role" + i + version);
            try {
                userRoleDAO.create(userRole);
            } catch (DuplicateEntityException e) {
                fail("Unexpected Exception " + e);
            }
//            user.setServiceUserRole(userRole);
            user.setUsername("user" + i + version);
            user.setPassword("password");
            try {
                userDAO.create(user);
            } catch (DuplicateEntityException e) {
                fail("Unexpected Exception " + e);
            }
            serviceDAO.addUser(serviceId, version, user);
        }
        ServiceUserDO[] users = serviceDAO.getUsers(serviceId, version);
        assertEquals(2, users.length);
        for (int i = 0; i < users.length; i++) {
            ServiceUserDO user = users[i];
            assertNotNull(user.getPassword());
            assertNotNull(user.getUsername());
        }
    }


    public void testDeleteServiceUser() {
        String serviceId = "TestDeleteUsersService";
        String version = String.valueOf(System.currentTimeMillis());
        createTestService(serviceId, version);

        ServiceDO service = serviceDAO.getService(serviceId, version);
        assertNotNull(service);
        for (int i = 0; i < 2; i++) {
            ServiceUserDO user = new ServiceUserDO();
            ServiceUserRoleDO userRole = new ServiceUserRoleDO();
            userRole.setRole("Role" + i + version);
            try {
                userRoleDAO.create(userRole);
            } catch (DuplicateEntityException e) {
                fail("Unexpected Exception " + e);
            }
//            user.setServiceUserRole(userRole);
            user.setUsername("user" + i + version);
            user.setPassword("password");
            try {
                userDAO.create(user);
            } catch (DuplicateEntityException e) {
                fail("Unexpected Exception " + e);
            }
            serviceDAO.addUser(serviceId, version, user);
        }
        ServiceUserDO[] users = serviceDAO.getUsers(serviceId, version);
        assertEquals(2, users.length);
        AxisService axisService = new AxisService("Test");

        for (int i = 0; i < users.length; i++) {
            ServiceUserDO user = users[i];
            if (i == 0) {
                serviceDAO.removeServiceUser(serviceId, version, user, axisService);
            }
            assertNotNull(user.getPassword());
            assertNotNull(user.getUsername());
        }

        //test if the user being deleted from the service
        users = serviceDAO.getUsers(serviceId, version);
        assertEquals(1, users.length);

    }

    public void testAddParameters() {
        String serviceId = "TestAddParamsService";
        String version = String.valueOf(System.currentTimeMillis());
        createTestService(serviceId, version);

        ServiceDO service = serviceDAO.getService(serviceId, version);
        assertNotNull(service);
        for (int i = 0; i < 2; i++) {
            ServiceParameterDO param = new ServiceParameterDO();
            param.setName("param" + i);
            param.setValue("test");
            serviceDAO.addParameter(serviceId, version, param);
        }
        ServiceParameterDO[] parameters = serviceDAO.getParameters(serviceId, version);
        assertEquals(2, parameters.length);
    }

    public void testAddPolicies() {
        String serviceId = "TestAddPoliciesService";
        String version = String.valueOf(System.currentTimeMillis());
        createTestService(serviceId, version);

        ServiceDO service = serviceDAO.getService(serviceId, version);
        assertNotNull(service);
        for (int i = 0; i < 2; i++) {
            ServicePolicyDO policy = new ServicePolicyDO();
            policy.setPolicy("<policy>test</policy>");
            policy.setType(1);
            policy.setUuid(version + i);
            serviceDAO.addPolicy(serviceId, version, policy);
        }
        ServicePolicyDO[] policies = serviceDAO.getPolicies(serviceId, version);
        assertEquals(2, policies.length);
        for (int i = 0; i < policies.length; i++) {
            ServicePolicyDO policy = policies[i];
            assertEquals("<policy>test</policy>", policy.getPolicy());
        }
    }

    public void testUpdatePolicy() {
        String serviceId = "TestUpdatePolicyService";
        String version = String.valueOf(System.currentTimeMillis());
        createTestService(serviceId, version);

        ServiceDO service = serviceDAO.getService(serviceId, version);
        assertNotNull(service);
        ServicePolicyDO policy = new ServicePolicyDO();
        policy.setPolicy("<policy>test</policy>");
        policy.setType(1);
        policy.setUuid(version);
        serviceDAO.addPolicy(serviceId, version, policy);

        policy.setPolicy("<policy>new-test</policy>");
        try {
            serviceDAO.updatePolicy(policy);
            ServicePolicyDO[] policies = serviceDAO.getPolicies(serviceId, version);
            assertEquals("<policy>new-test</policy>", policies[0].getPolicy());
        } catch (ServicePolicyNotFoundException e) {
            e.printStackTrace();
            fail();
        }
    }

    public void testDelete() {
        String serviceId = "TestDeleteService";
        String version = String.valueOf(System.currentTimeMillis());
        createTestService(serviceId, version);

        ServiceDO service = serviceDAO.getService(serviceId, version);
        assertNotNull(service);
        for (int i = 0; i < 2; i++) {
            OperationDO op = new OperationDO();
            op.setName("op" + i);
            serviceDAO.addOperation(serviceId, version, op);
        }
        service = serviceDAO.getService(serviceId, version);
        assertNotNull(service);

        serviceDAO.deleteService(serviceId, version);
        service = serviceDAO.getService(serviceId, version);
        assertNull(service);
    }


    public void testAddRoles() {
        String serviceId = "TestAddRolesService";
        String version = String.valueOf(System.currentTimeMillis());
        createTestService(serviceId, version);

        ServiceDO service = serviceDAO.getService(serviceId, version);
        assertNotNull(service);
        for (int i = 0; i < 2; i++) {
            ServiceUserRoleDO role = new ServiceUserRoleDO();
            role.setRole("Role_X" + i + version);
            try {
                userRoleDAO.create(role);
            } catch (DuplicateEntityException e) {
                fail("Unexpected Exception " + e);
            }
//
            serviceDAO.addRole(serviceId, version, role);
        }
        ServiceUserRoleDO[] roles = serviceDAO.getRoles(serviceId, version);
        assertEquals(2, roles.length);
        for (int i = 0; i < roles.length; i++) {
            ServiceUserRoleDO role = roles[i];
            assertNotNull(role.getRole());
        }

    }


    public void testDeleteRole() {
        String serviceId = "TestDeleteRolesService";
        String version = String.valueOf(System.currentTimeMillis());
        createTestService(serviceId, version);

        ServiceDO service = serviceDAO.getService(serviceId, version);
        assertNotNull(service);
        for (int i = 0; i < 2; i++) {
            ServiceUserRoleDO userRole = new ServiceUserRoleDO();
            userRole.setRole("Role_Y" + i + version);
            try {
                userRoleDAO.create(userRole);
            } catch (DuplicateEntityException e) {
                fail("Unexpected Exception " + e);
            }
//
            serviceDAO.addRole(serviceId, version, userRole);
        }
        ServiceUserRoleDO[] roles = serviceDAO.getRoles(serviceId, version);
        assertEquals(2, roles.length);
        AxisService axisService = new AxisService("Test");
        for (int i = 0; i < roles.length; i++) {
            ServiceUserRoleDO role = roles[i];
            if (i == 0) {
                serviceDAO.removeServiceRole(serviceId, version, role, axisService);
            }
            assertNotNull(role.getRole());
        }

        //test if the role being deleted from the service
        roles = serviceDAO.getRoles(serviceId, version);
        assertEquals(1, roles.length);


    }

}
