/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence;

import org.wso2.wsas.persistence.dataobject.ServerConfigurationDO;
import org.wso2.wsas.persistence.exception.DuplicateEntityException;

/**
 *
 */
public class ServerConfigurationDAOTest extends AbstractDAOTestCase {
    public void testConfigurationProperty() {
        ServerConfigurationDO serverConfig = new ServerConfigurationDO();
        String name = "Config" + System.currentTimeMillis();
        serverConfig.setName(name);
        serverConfig.setValue("value");
        try {
            serverConfigDAO.create(serverConfig);
        } catch (DuplicateEntityException e) {
            fail("Unexpected Exception " + e);
        }
        assertEquals("value", serverConfigDAO.getConfigurationProperty(name));

        serverConfigDAO.updateConfigurationProperty(name, "new-value");
        assertEquals("new-value", serverConfigDAO.getConfigurationProperty(name));
    }
}
