/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence;

import org.wso2.wsas.persistence.dao.OperationDAO;
import org.wso2.wsas.persistence.dataobject.*;

/**
 *
 */
public class ModuleDAOTest extends AbstractDAOTestCase {

    public void testAddModule() {
        String name = "TestAddModule";
        String version = String.valueOf(System.currentTimeMillis());

        createTestModule(name, version);

        ModuleDO moduleDO = modDAO.getModule(name, version);
        assertNotNull(moduleDO);
        assertEquals(name, moduleDO.getModuleIdentifierDO().getName());
        assertEquals(version, moduleDO.getModuleIdentifierDO().getVersion());
    }

    public void testDeleteModule() {
        String name = "TestDeleteModule";
        String version = String.valueOf(System.currentTimeMillis());
        createTestModule(name, version);
        ModuleDO moduleDO = modDAO.getModule(name, version);
        assertNotNull(moduleDO);
        modDAO.deleteModule(name, version);
        moduleDO = modDAO.getModule(name, version);
        assertNull(moduleDO);
    }

    public void testAddEngagedService() {
        String moduleName = "TestAddEngagedServiceModule";
        String version = String.valueOf(System.currentTimeMillis());
        createTestModule(moduleName, version);

        for (int i = 0; i < 2; i++) {
            String sid = "EngagedService" + i;
            ServiceDO service = createTestService(sid, version);
            modDAO.addEngagedService(moduleName, version, service);
        }

        ModuleDO moduleDO = modDAO.getModule(moduleName, version);
        assertNotNull(moduleDO);
        ServiceDO[] engagedServices = modDAO.getEngagedServices(moduleName, version);
        assertEquals(2, engagedServices.length);
        for (int i = 0; i < engagedServices.length; i++) {
            ServiceDO engagedService = engagedServices[i];
            assertEquals(version, engagedService.getServiceIdentifierDO().getVersion());
        }
    }

    public void testAddEngagedOperations() {
        String moduleName = "TestAddEngagedOpModule";
        String version = String.valueOf(System.currentTimeMillis());
        createTestModule(moduleName, version);

        String sid = "EngageOperationService";
        ServiceDO service = createTestService(sid, version);
        for (int i = 0; i < 2; i++) {
            OperationDO op = new OperationDO();
            op.setName("op" + i);
            service.addOperation(op);
        }
        serviceDAO.updateService(service);

        OperationDO[] operations = serviceDAO.getOperations(sid, version);
        assertEquals(2, operations.length);
        for (int i = 0; i < operations.length; i++) {
            OperationDO operation = operations[i];
            modDAO.addEngagedOperation(moduleName, version, operation);
        }

        OperationDO[] engagedOperations = modDAO.getEngagedOperations(moduleName, version);
        assertEquals(2, engagedOperations.length);
        OperationDAO opDAO = new OperationDAO(hbConfig);
        for (int i = 0; i < engagedOperations.length; i++) {
            OperationDO engagedOperation = engagedOperations[i];
            assertTrue(engagedOperation.getName().indexOf("op") != -1);
            assertEquals(sid, opDAO.getServiceIdentifier(engagedOperation).getServiceId());
            assertEquals(version, opDAO.getServiceIdentifier(engagedOperation).getVersion());
        }
    }

    public void testAddModulePolicy() {
        String moduleName = "TestAddPolicyModule";
        String version = String.valueOf(System.currentTimeMillis());
        createTestModule(moduleName, version);

        for (int i = 0; i < 2; i++) {
            ModulePolicyDO policy = new ModulePolicyDO();
            policy.setPolicy("<policy>p " + i + "</policy>");
            policy.setType(1);
            policy.setUuid(version);
            modDAO.addPolicy(moduleName, version, policy);
        }

        ModulePolicyDO[] policies = modDAO.getPolicies(moduleName, version);
        assertEquals(2, policies.length);
        for (int i = 0; i < policies.length; i++) {
            ModulePolicyDO policy = policies[i];
            assertEquals(1, policy.getType());
            assertEquals(version, policy.getUuid());
            ModuleDO moduleDO = policy.getModule();
            assertEquals(moduleName, moduleDO.getModuleIdentifierDO().getName());
            assertEquals(version, moduleDO.getModuleIdentifierDO().getVersion());
            ServiceDO[] engagedServices = modDAO.getEngagedServices(moduleName, version);
            assertEquals(0, engagedServices.length);
        }
    }

    public void testAddModuleParameter() {
        String moduleName = "TestAddParameterModule";
        String version = String.valueOf(System.currentTimeMillis());
        createTestModule(moduleName, version);

        for (int i = 0; i < 2; i++) {
            ModuleParameterDO param = new ModuleParameterDO();
            param.setName("param" + i);
            param.setValue("test");
            modDAO.addParameter(moduleName, version, param);
        }

        ModuleParameterDO[] params = modDAO.getParameters(moduleName, version);
        assertEquals(2, params.length);
        for (int i = 0; i < params.length; i++) {
            ModuleParameterDO policy = params[i];
            assertTrue(policy.getName().indexOf("param") == 0);
            assertEquals("test", policy.getValue());
            ModuleDO moduleDO = policy.getModule();
            assertEquals(moduleName, moduleDO.getModuleIdentifierDO().getName());
            assertEquals(version, moduleDO.getModuleIdentifierDO().getVersion());
            ServiceDO[] engagedServices = modDAO.getEngagedServices(moduleName, version);
            assertEquals(0, engagedServices.length);
        }
    }

    public void testAddEngagedServiceGroup() {
        String moduleName = "TestAddEngagedServiceGroupModule";
        String version = String.valueOf(System.currentTimeMillis());
        createTestModule(moduleName, version);

        for (int i = 0; i < 2; i++) {
            String sgName = "EngagedServiceGroup" + i + version;
            ServiceGroupDO service = createTestServiceGroup(sgName);
            modDAO.addEngagedServiceGroup(moduleName, version, service);
        }

        ModuleDO moduleDO = modDAO.getModule(moduleName, version);
        assertNotNull(moduleDO);
        ServiceGroupDO[] engagedSGs = modDAO.getEngagedServiceGroups(moduleName, version);
        assertEquals(2, engagedSGs.length);
        for (int i = 0; i < engagedSGs.length; i++) {
            ServiceGroupDO engagedSG = engagedSGs[i];
            assertTrue(engagedSG.getName().indexOf("EngagedServiceGroup") == 0);
        }
    }
}
