/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence;

import org.wso2.wsas.persistence.dataobject.MessageDO;
import org.wso2.wsas.persistence.dataobject.OperationDO;
import org.wso2.wsas.persistence.dataobject.ServiceDO;
import org.wso2.wsas.persistence.dataobject.ServiceIdentifierDO;
import org.wso2.wsas.persistence.exception.DuplicateEntityException;

/**
 *
 */
public class MessageDAOTest extends AbstractDAOTestCase {
    public void testGetMaxMsgSequence() {
        ServiceDO service = new ServiceDO();
        setServiceGroup(service);
        ServiceIdentifierDO id = new ServiceIdentifierDO();
        String serviceId = "TestMessageService" + System.currentTimeMillis();
        id.setServiceId(serviceId);
        String version = "V" + System.currentTimeMillis();
        id.setVersion(version);
        service.setServiceIdentifierDO(id);

        OperationDO operation = new OperationDO();
        String opName = "testOperation";
        operation.setName(opName);
        service.addOperation(operation);
        try {
            serviceDAO.create(service);
        } catch (DuplicateEntityException e) {
            fail("Unexpected Exception " + e);
        }

        assertNotNull(serviceDAO.getService(serviceId, version));

        for (int i = 0; i < 10; i++) {
            MessageDO message = new MessageDO();
            message.setType(i);
            message.setSequence(i);
            message.setServiceId(serviceId);
            message.setServiceVersion(version);
            message.setXml("<hello>Hi</hello>");
            message.setOperationName(operation.getName());

            messageDAO.addMessage(message);
            assertEquals(i, messageDAO.getMaxMessageSequence(serviceId, version, opName));
        }

        MessageDO msgSearch = new MessageDO();
        msgSearch.setServiceId(serviceId);
        msgSearch.setServiceVersion(version);
        msgSearch.setOperationName(opName);
        MessageDO[] messages = messageDAO.getMessages(msgSearch);
        assertEquals(10, messages.length);
    }
}
