/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence;

import org.wso2.wsas.persistence.dataobject.LoggerDO;
import org.wso2.wsas.persistence.exception.DuplicateEntityException;

/**
 *
 */
public class LoggerDAOTest extends AbstractDAOTestCase {

    public void testLoggerDAO() {

        LoggerDO loggerDO = new LoggerDO();
        String loggerName = "org.wso2.wsas." + System.currentTimeMillis();
        loggerDO.setName(loggerName);
        loggerDO.setLogLevel("DEBUG");
        loggerDO.setAdditivity(true);

        try {
            // test create
            loggerDAO.create(loggerDO);

            // test retrive
            loggerDO = loggerDAO.getLoggerDO(loggerName);
            assertEquals(loggerDO.getName(), loggerName);
            assertEquals(loggerDO.getLogLevel(), "DEBUG");

            // test update to existing one
            loggerDO.setLogLevel("INFO");
            loggerDO.setName(loggerName);
            loggerDAO.updateLoggerDO(loggerDO);

            // test retrive
            loggerDO = loggerDAO.getLoggerDO(loggerName);
            assertEquals(loggerDO.getName(), loggerName);
            assertEquals(loggerDO.getLogLevel(), "INFO");

            // update from new one
            loggerDO = new LoggerDO();
            loggerDO.setLogLevel("WARN");
            loggerDO.setName("com.wso2");
            loggerDO.setAdditivity(true);
            loggerDAO.updateLoggerDO(loggerDO);

            // test retrive
            loggerDO = loggerDAO.getLoggerDO("com.wso2");
            assertEquals(loggerDO.getName(), "com.wso2");
            assertEquals(loggerDO.getLogLevel(), "WARN");
            assertEquals(loggerDO.getAdditivity(), true);

        } catch (Exception e) {
            e.printStackTrace();
            fail("Unexpected exception occured. " + e);
        }
    }
}
