/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence;

import org.wso2.wsas.persistence.dataobject.AppenderDO;
import org.wso2.wsas.persistence.dataobject.LoggerDO;
import org.wso2.wsas.persistence.exception.DuplicateEntityException;

import java.util.Set;

/**
 *
 */
public class AppenderDAOTest extends AbstractDAOTestCase {

    public void testAppenderDAO() {
        AppenderDO appenderDO = new AppenderDO();
        appenderDO.setName("MemoryAppender");
        appenderDO.setPattern("%5p [%d] %x %m%n");
        appenderDO.setLogFileName("/logs/log.txt");
        appenderDO.setIsFileAppender(true);

        try {
            appenderDAO.create(appenderDO);
            // find the appender with name
            appenderDO = appenderDAO.getAppenderDO("MemoryAppender");
            assertEquals(appenderDO.getName(), "MemoryAppender");
            assertEquals(appenderDO.getPattern(), "%5p [%d] %x %m%n");
            assertEquals(appenderDO.getLogFileName(), "/logs/log.txt");
            assertTrue(appenderDO.getIsFileAppender());

            //test existing record update
            appenderDO.setPattern("%5p [%d] %x");
            appenderDO.setLogFileName("/logs/log1.txt");

            appenderDAO.updateAppenderDO(appenderDO);

            appenderDO = appenderDAO.getAppenderDO("MemoryAppender");
            assertEquals(appenderDO.getName(), "MemoryAppender");
            assertEquals(appenderDO.getPattern(), "%5p [%d] %x");
            assertEquals(appenderDO.getLogFileName(), "/logs/log1.txt");

            System.out.println("is File appender " + appenderDO.getIsFileAppender());

            // test non existing record update
            appenderDO.setName("DailyRollingFileAppender");
            appenderDO.setPattern("%5p [%d] %x");
            appenderDO.setLogFileName("/logs/log1.txt");

            appenderDAO.updateAppenderDO(appenderDO);

            appenderDO = appenderDAO.getAppenderDO("DailyRollingFileAppender");
            assertEquals(appenderDO.getName(), "DailyRollingFileAppender");
            assertEquals(appenderDO.getPattern(), "%5p [%d] %x");
            assertEquals(appenderDO.getLogFileName(), "/logs/log1.txt");

        } catch (DuplicateEntityException e) {
            e.printStackTrace();
            fail("Unexpected exception in creating the appender DO");
        }
    }

    public void testAppenderLoggers() {

        AppenderDO appenderDO = new AppenderDO();
        appenderDO.setName("ConsoleAppender");
        appenderDO.setPattern("%5p [%d] %x %m%n");
        appenderDO.setLogFileName("/logs/log.txt");

        try {
            appenderDAO.create(appenderDO);
            // find the appender with name
            appenderDO = appenderDAO.getAppenderDO("ConsoleAppender");

            LoggerDO loggerDO = new LoggerDO();
            loggerDO.setName("org.wso2.wsas");
            loggerDO.setLogLevel("DEBUG");

            loggerDAO.create(loggerDO);

            appenderDAO.addLogger(appenderDO, loggerDO);

            Set loggers = appenderDAO.getLoggers(appenderDO);

            loggerDO = (LoggerDO) loggers.iterator().next();
            assertEquals(loggerDO.getName(), "org.wso2.wsas");
            assertEquals(loggerDO.getLogLevel(), "DEBUG");


        } catch (DuplicateEntityException e) {
            e.printStackTrace();
            fail("Unexpected exception in creating the appender DO");
        }


    }
}
