/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence;

import junit.framework.TestCase;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.persistence.dao.*;
import org.wso2.wsas.persistence.dataobject.*;
import org.wso2.wsas.persistence.exception.DuplicateEntityException;
import org.wso2.wsas.util.HibernateConfig;
import org.wso2.wsas.util.HibernateConfigFactory;

/**
 *
 */
public class AbstractDAOTestCase extends TestCase {

    protected HibernateConfig hbConfig;
    protected ModuleDAO modDAO;
    protected ServiceDAO serviceDAO;
    protected ServiceGroupDAO serviceGroupDAO;
    protected UserDAO userDAO;
    protected UserRoleDAO userRoleDAO;
    protected ServerConfigurationDAO serverConfigDAO;
    protected MessageDAO messageDAO;
    protected AppenderDAO appenderDAO;
    protected LoggerDAO loggerDAO;

    protected void setUp() throws Exception {
        System.setProperty(ServerConstants.DERBY_HOME, "conf");
        hbConfig = HibernateConfigFactory.getDefaultConfig(ServerConstants.WSO2WSAS_HB_CONFIG_KEY);
        modDAO = new ModuleDAO(hbConfig);
        serviceDAO = new ServiceDAO(hbConfig);
        serviceGroupDAO = new ServiceGroupDAO(hbConfig);
        userDAO = new UserDAO(hbConfig);
        userRoleDAO = new UserRoleDAO(hbConfig);
        serverConfigDAO = new ServerConfigurationDAO(hbConfig);
        messageDAO = new MessageDAO(hbConfig);
        appenderDAO = new AppenderDAO(hbConfig);
        loggerDAO = new LoggerDAO(hbConfig);
    }

    protected ModuleDO createTestModule(String name, String version) {
        ModuleDO mod = new ModuleDO();
        ModuleIdentifierDO modId = new ModuleIdentifierDO();
        modId.setName(name);
        modId.setVersion(version);
        mod.setModuleIdentifierDO(modId);
        try {
            modDAO.create(mod);
        } catch (DuplicateEntityException e) {
            fail("Unexpected Exception " + e);
        }
        return mod;
    }

    protected ServiceDO createTestService(String sid, String version) {
        ServiceGroupDO sgDO = new ServiceGroupDO();
        sgDO.setName("test-sg-" + System.currentTimeMillis());
        new ServiceGroupDAO(hbConfig).createServiceGroup(sgDO);

        ServiceDO service = new ServiceDO();
        ServiceIdentifierDO serviceId = new ServiceIdentifierDO();
        serviceId.setServiceId(sid);
        serviceId.setVersion(version);
        service.setServiceIdentifierDO(serviceId);
        service.setServiceGroup(sgDO);
        try {
            serviceDAO.create(service);
        } catch (DuplicateEntityException e) {
            fail("Unexpected Exception " + e);
        }
        return service;
    }

    protected ServiceGroupDO createTestServiceGroup(String name) {
        ServiceGroupDO sg = new ServiceGroupDO();
        sg.setName(name);
        serviceGroupDAO.createServiceGroup(sg);
        return sg;
    }

    protected void setServiceGroup(ServiceDO service) {
        ServiceGroupDO sgDO = new ServiceGroupDO();
        sgDO.setName("test-sg" + System.currentTimeMillis());
        new ServiceGroupDAO(hbConfig).createServiceGroup(sgDO);
        service.setServiceGroup(sgDO);
    }
}
