/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas;

import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.Constants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.util.ServerUtils;

import javax.xml.namespace.QName;

/**
 * All WSAS Standalone tests will be done using this testcase.
 */
public class TomcatServerTest extends AbstractTestCase {
    protected QName operationName = new QName("getVersion");

     public static Test suite() {
        return new TestSetup(new TestSuite(TomcatServerTest.class)) {
            protected void setUp() throws Exception {
                System.setProperty(ServerConstants.DERBY_HOME, "target/test-classes");
                System.setProperty(ServerConstants.WSO2WSAS_ADMIN_PASSWORD, "abc");
                System.setProperty(ServerConstants.WSO2WSAS_HOME, "target/tomcat_test");
                System.setProperty(ServerConstants.WSO2WSAS_SERVER_XML,
                                   "target/tomcat_test/conf/server.xml");
                System.setProperty("java.io.tmpdir","target/tomcat_test/tmp");

                ServerUtils serverUtils = new ServerUtils();
                serverUtils.startServer();
            }

            protected void tearDown() throws Exception {
            }


        };
    }

    /*protected void setUp() throws Exception {
        System.setProperty(ServerConstants.DERBY_HOME, "conf");
        System.setProperty(ServerConstants.WSO2WSAS_ADMIN_PASSWORD, "abc");
        System.setProperty(ServerConstants.WSO2WSAS_HOME, "target/tomcat_test");
        System.setProperty(ServerConstants.WSO2WSAS_SERVER_XML,
                           "target/tomcat_test/conf/server.xml");

        ServerUtils serverUtils = new ServerUtils();
        System.err.println("###### Gonna start server");
        serverUtils.startServer();
        System.err.println("####### Started server");
    }*/

    public void testVersionSync() throws Exception {

        try {
            EndpointReference targetEPR =
                    new EndpointReference("http://" + NetworkUtils.getLocalHostname() + ":"
                                          + (TestConstants.TESTING_PORT)
                                          + "/" + ServerConstants.SERVICE_PATH +
                                          "/version");

            testConnect(targetEPR);
            removeProperties();
            ServiceClient sender = new ServiceClient();
            Options options = new Options();
            options.setTo(targetEPR);
            options.setTransportInProtocol(Constants.TRANSPORT_HTTP);
            options.setUseSeparateListener(false);
            sender.setOptions(options);
            options.setAction("urn:getVersion");
            OMElement result = sender.sendReceive(getTestPayload());
            String versionText = result.getFirstElement().getText();

            int i = versionText
                    .indexOf("Hello I am WSO2 WSAS version service. My version is TEST");
            assertTrue(i != -1);
        } catch (Exception e) {
            e.printStackTrace();
            fail("Exception occurred during startup " + e);
        }
    }

    public void _testEchoXMLSync() throws Exception {

        EndpointReference targetEPR = new EndpointReference(
                "http://" + NetworkUtils.getLocalHostname() + ":" +
                (TestConstants.TESTING_PORT)
                + "/" + ServerConstants.SERVICE_PATH + "/" +
                TestConstants.ECHO_SERVICE_NAME.getLocalPart() + "/" +
                TestConstants.ECHO_OPERATION.getLocalPart());

        testConnect(targetEPR);
        removeProperties();
        OMElement payload = createEchoPayload();
        Options options = new Options();
        options.setTo(targetEPR);
        options.setTransportInProtocol(Constants.TRANSPORT_HTTP);


        ServiceClient sender = new ServiceClient();
        sender.setOptions(options);

        OMElement result = sender.sendReceive(payload);
        OMElement returnElement = result.getFirstChildWithName(new QName("return"));

        assertXMLEqual(payload.getFirstElement().toString(),
                       returnElement.getFirstElement().toString());
        assertTrue(true);
    }

    public void _testAxis1DeployerSync() throws Exception {
        EndpointReference targetEPR = new EndpointReference(
                "http://" + NetworkUtils.getLocalHostname() + ":" +
                (TestConstants.TESTING_PORT)
                + "/" + ServerConstants.SERVICE_PATH + "/" + "A1Service");
        testConnect(targetEPR);
        removeProperties();

        OMElement payload = createCalculatorPayload();
        Options options = new Options();
        options.setTo(targetEPR);

        ServiceClient sc = new ServiceClient();
        sc.setOptions(options);
        options.setTimeOutInMilliSeconds(1000000);

        OMElement omElement = sc.sendReceive(payload);
        assertNotNull(omElement);


    }

}
