/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.addressing.EndpointReference;
import org.custommonkey.xmlunit.XMLTestCase;
import org.wso2.wsas.util.ServerUtils;

import javax.xml.namespace.QName;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;

public class AbstractTestCase extends XMLTestCase {

    protected ServerUtils serverUtils;
    protected Thread serverThread;
    protected long wsasTestTimeout = 2*60000;

    protected OMElement createEchoPayload() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://echo.services.wsas.wso2.org", "my");
        OMElement method = fac.createOMElement("echoOMElement", omNs);
        OMElement value = fac.createOMElement("myValue", omNs);
        value.addChild(
                fac.createOMText(value, "Isaac Asimov, The Foundation Trilogy"));
        method.addChild(value);
        return method;
    }

    protected OMElement createCalculatorPayload() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://util.wso2.wsas.org/xsd","my");
        OMElement method = fac.createOMElement("add",omNs);
        OMElement value1 = fac.createOMElement("firstNumber",omNs);
        value1.setText("10");
        OMElement value2 = fac.createOMElement("secondNumber",omNs);
        value2.setText("20");
        OMElement value3 = fac.createOMElement("thirdNumber",omNs);
        value3.setText("30");
        method.addChild(value1);
        method.addChild(value2);
        method.addChild(value3);
        return method;
    }

    protected static OMElement getTestPayload() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        QName requtestQName =
                new QName("http://version.services.wsas.wso2.org/xsd", "getVersionRequest");

        OMNamespace ns =
                fac.createOMNamespace(requtestQName.getNamespaceURI(), "ns");
        return fac.createOMElement(requtestQName.getLocalPart(), ns);

    }

    public void testConnect(EndpointReference epr) throws Exception {
        long start = System.currentTimeMillis();
        URL url;
        try {
            url = new URL(epr.getAddress());
        } catch (MalformedURLException e) {
            throw new Exception(e);
        }

        while (true) {
            try {
                HttpURLConnection httpCon;
                httpCon = (HttpURLConnection) url.openConnection();
                httpCon.setDoOutput(true);
                httpCon.setDoInput(true);
                httpCon.setUseCaches(false);
                httpCon.setRequestMethod("GET");
                HttpURLConnection.setFollowRedirects(true);

                httpCon.connect();
                httpCon.disconnect();
                Thread.sleep(1000);
                break;
            } catch (IOException e) {
                String timeoutValue = System.getProperty("wsas.test.timeout");
                if (timeoutValue != null) {
                    wsasTestTimeout = Long.parseLong(timeoutValue);
                }
                if(System.currentTimeMillis() - start >= wsasTestTimeout){
                    throw new Exception("Could not connect to WSO2 WSAS instance. " +
                                        "Timeout occurred.");
                }
                try {
                    Thread.sleep(2000);
                } catch (InterruptedException e1) {
                    break;
                }
            }
        }

    }

    /**
     * Removing System properties at client side
     */
    public void removeProperties() {
        System.getProperties().remove(org.apache.axis2.Constants.AXIS2_CONF);
    }

    public void verifySOAPEnvelopeContentUsingHandler(OMElement element) {
        int index = 1;
        for (Iterator iterator = element.getChildElements(); iterator.hasNext();) {
            OMElement omElement = (OMElement) iterator.next();
            if (index++ == 1) {
                assertTrue((omElement != null) && "firstNumber".equals(omElement.getLocalName()));
            } else if (index++ == 2) {
                assertTrue((omElement != null) && "secondNumber".equals(omElement.getLocalName()));
            } else if (index++ == 3) {
                assertTrue((omElement != null) && "thirdNumber".equals(omElement.getLocalName()));
            }

        }
    }

}
