/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.util;

import org.apache.log4j.Logger;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.ServerManagement;
import org.wso2.wsas.TomcatServerCache;

public class SystemRestarter implements Runnable {

    private Controllable newInstance;
    private Controllable currentInstance;
    private static Logger log = Logger.getLogger(SystemRestarter.class);
    private boolean gracefulRestart;

    public SystemRestarter(boolean gracefulRestart,
                           Controllable currentInstance,
                           Controllable newInstance,
                           String axis2RepoLocation,
                           Monitor m) {

        this.currentInstance = currentInstance;
        this.newInstance = newInstance;
        this.newInstance.setAxis2RepoLocation(axis2RepoLocation);
        this.newInstance.setMonitor(m);
        this.gracefulRestart = gracefulRestart;
    }

    public void run() {
        try {
            System.setProperty(ServerConstants.WSO2WSAS_START_TIME,
                               String.valueOf(System.currentTimeMillis()));
            if (gracefulRestart) {
                log.info("Gracefully restarting WSO2 WSAS...");
                new ServerManagement(currentInstance.getConfigurationContext().
                        getAxisConfiguration().getTransportsIn()).startMaintenance();
            } else {
                log.info("Restarting WSO2 WSAS...");
            }
            TomcatServerCache.removeAllConnectors();
            this.currentInstance.stopListeners();
            this.newInstance.startServer();
        } catch (Exception e) {
            String msg = "Cannot restart system";
            log.fatal(msg, e);
        }
    }
}
