/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.util;

import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.ServerConstants;

import java.util.Arrays;
import java.util.List;

/**
 * This class will filter admin services and modules. WSAS specific services are hard
 * coded and rest is plugable via services.xml.
 */
public class SystemFilter {

    private static ServerConfiguration serverConfig = ServerConfiguration.getInstance();

    public static boolean isFilteredOutService(String serviceGroupName) {
        String[] strings = serverConfig.getProperties("SystemFilter.ServiceGroups.Name");
        List list = Arrays.asList(strings);
        return list.contains(serviceGroupName) ||
               serviceGroupName.endsWith(ServerConstants.TRACER_SERVICE_GROUP) ||
               serviceGroupName.endsWith(ServerConstants.STATISTICS_SERVICE_GROUP);
    }

    public static boolean isFilteredOutModule(String moduleName) {
        String[] strings = serverConfig.getProperties("SystemFilter.Modules.Name");
        List list = Arrays.asList(strings);
        return list.contains(moduleName);
    }
}
