/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.util;

import org.wso2.utils.i18n.Messages;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

/**
 * Monitor thread.
 */
public class Monitor extends Thread {
    private ServerSocket serverSocket;
    private String key;

    public static String getKey() {
        return Messages.getMessage("serverVersionRaw") + " " +
               Messages.getMessage("serverBuiltOnRaw");
    }

    public Monitor(int port) {
        key = getKey();
        try {
            if (port < 0) {
                return;
            }
            setDaemon(true);
            serverSocket = new ServerSocket(port, 1, InetAddress.getByName("127.0.0.1"));
            if (port == 0) {
                port = serverSocket.getLocalPort();
                System.out.println(port);
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        if (serverSocket == null) {
            throw new RuntimeException(Messages.getMessage("InvalidAdminPort", Integer.toString(port)));
        }
    }

    public void run() {
        while (true) {
            if (this.serverSocket == null) {
                return;
            }
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                LineNumberReader lin =
                        new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                String key = lin.readLine();
                if (!this.key.equals(key)) {
                    continue;
                }

                String cmd = lin.readLine();
                if ("STOP".equals(cmd)) {
                    socket.getOutputStream().write("DONE\r\n".getBytes());
                    socket.getOutputStream().flush();
                    try {
                        socket.close();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        this.serverSocket.close();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.exit(0);
                } else if ("RESTART".equals(cmd)) {
                    socket.getOutputStream().write("DONE\r\n".getBytes());
                    socket.getOutputStream().flush();
                    try {
                        socket.close();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        this.serverSocket.close();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                } else if ("STATUS".equals(cmd)) {
                    socket.getOutputStream().write("OK\r\n".getBytes());
                    socket.getOutputStream().flush();
                }
            } catch (Exception e) {
                System.err.println(e.toString());
            } finally {
                if (socket != null) {
                    try {
                        socket.close();
                    } catch (Exception e) {
                    }
                }
                socket = null;
            }
        }
    }
}
