/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.util;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.log4j.Logger;

import javax.xml.namespace.QName;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 *
 */
public class MIMEType2FileExtensionMap {
    public static String mappingFileName = "conf/mime-mappings.xml";

    private Map extensionToMimeMap;
    public static MIMEType2FileExtensionMap instance;
    private static Logger log = Logger.getLogger(MIMEType2FileExtensionMap.class);

    public static MIMEType2FileExtensionMap getInstance() {
        if (instance == null) {
            instance = new MIMEType2FileExtensionMap();
        }
        return instance;
    }

    private MIMEType2FileExtensionMap() {
        extensionToMimeMap = new HashMap();
        init();
    }

    public String getMIMEType(File file) {
        String filename = file.getName();
        int index = filename.lastIndexOf(".");
        if (index == -1 || index == filename.length() - 1) {
            return "application/octet-stream";
        } else {
            String extension = filename.substring(index + 1);
            String contentType = (String) extensionToMimeMap.get(extension);
            return contentType != null ? contentType : "application/octet-stream";
        }
    }

    private void init() {

        try {
            OMElement doc = new StAXOMBuilder(mappingFileName).getDocumentElement();
            for (Iterator childIter = doc.getChildElements(); childIter.hasNext();) {
                OMElement mappingEle = (OMElement) childIter.next();
                String ext = mappingEle.getFirstChildWithName(new QName("Extension")).getText();
                String mimeType = mappingEle.getFirstChildWithName(new QName("MimeType")).getText();
                extensionToMimeMap.put(ext, mimeType);
            }
        } catch (Exception e) {
            String msg = "Unable to load all MIME Mappings";
            e.printStackTrace();
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        }
    }
}
