/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.util;

import org.apache.axis2.context.ConfigurationContext;
import org.wso2.utils.ServerException;
import org.wso2.wsas.ServerConstants;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

/**
 *
 */
public class FileDownloadUtil {

    public FileDownloadUtil() {
    }

    public synchronized boolean acquireResource(ConfigurationContext configurationContext,
                                                HttpServletRequest request,
                                                HttpServletResponse response)
            throws ServerException {
        OutputStream out;
        try {
            out = response.getOutputStream();
        } catch (IOException e) {
            throw new ServerException("Unable to retrieve file ", e);
        }

        Map fileResourcesMap =
                (Map) configurationContext.
                        getProperty(ServerConstants.FILE_RESOURCE_MAP);
        String filename = (String) fileResourcesMap.get(request.getParameter("id"));
        if (filename == null) {
            try {
                out.write("The requested file was not found on the server".getBytes());
                out.flush();
                out.close();
            } catch (IOException e) {
                throw new ServerException("Unable to write output to HttpServletResponse OutputStream",
                                          e);
            }
            return false;
        }

        try {
            File file = new File(filename);
            FileInputStream in = new FileInputStream(file);
            byte[] b = new byte[(int) file.length()];
            response.setContentType(MIMEType2FileExtensionMap.getInstance().getMIMEType(file));
            response.setContentLength((int) file.length());
            response.setHeader("Content-Disposition", "filename=" + file.getName());
            int lengthRead = in.read(b);
            if (lengthRead != -1) {
                out.write(b);
            }
            out.flush();
            out.close();
            in.close();
            return true;
        } catch (IOException e) {
            throw new ServerException("Unable to retrieve file ", e);
        }
    }
}
