/*
 * Copyright 2006,2007 WSO2, Inc. http://www.wso2.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wso2.wsas.transport.util;

import org.apache.axiom.attachments.utils.IOUtils;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.description.AxisService;
import org.apache.ws.commons.schema.XmlSchema;
import org.wso2.utils.NetworkUtils;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.ServerManager;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;

public class XsdUtil {

    public static void printXsd(HttpServletRequest request, HttpServletResponse response,
                                ConfigurationContext configCtx, String serviceName,
                                AxisService axisService)
            throws IOException {
        OutputStream outputStream = response.getOutputStream();
        String contextRoot = request.getContextPath();
        if (axisService != null) {
            if (!axisService.isActive()) {
                response.setContentType("text/html");
                outputStream.write(("<h4>Service " +
                                    serviceName +
                                    " is inactive. Cannot display Schema.</h4>").getBytes());
                outputStream.flush();
                return;
            }


            axisService.populateSchemaMappings();
            Map schemaMappingtable =
                    axisService.getSchemaMappingTable();
            String xsds = request.getParameter("xsd");
            if (xsds != null && xsds.trim().length() != 0) {
                response.setContentType("text/xml");
                XmlSchema schema =
                        (XmlSchema) schemaMappingtable.get(xsds);
                if (schema == null) {
                    int dotIndex = xsds.indexOf('.');
                    if (dotIndex > 0) {
                        String schemaKey = xsds.substring(0, dotIndex);
                        schema = (XmlSchema) schemaMappingtable.get(schemaKey);
                    }
                }
                if (schema != null) {
                    //schema is there - pump it outs
                    schema.write(new OutputStreamWriter(outputStream, "UTF8"));
                    outputStream.flush();
                    outputStream.close();
                } else {
                    InputStream in = axisService.getClassLoader()
                            .getResourceAsStream(DeploymentConstants.META_INF + "/" + xsds);
                    if (in != null) {
                        outputStream.write(IOUtils.getStreamAsByteArray(in));
                        outputStream.flush();
                        outputStream.close();
                    } else {
                        response.sendError(HttpServletResponse.SC_NOT_FOUND);
                    }
                }
                return;
            }

            ArrayList schemas = axisService.getSchema();
            if (schemas.size() == 1) {
                response.setContentType("text/xml");
                // Write to the output stream
                processSchema((XmlSchema) schemas.get(0), outputStream, contextRoot, request);

            } else {
                String idParam = request.getParameter("id");
                if (idParam != null) {
                    XmlSchema schema = axisService.getSchema(Integer.parseInt(idParam));
                    if (schema != null) {
                        response.setContentType("text/xml");
                        processSchema(schema, outputStream, contextRoot, request);
                    } else {
                        response.setContentType("text/html");
                        outputStream.write("<h4>Schema not found!</h4>".getBytes());
                    }
                } else {
                    String ipAddress = "http://" + NetworkUtils.getLocalHostname() + ":" +
                                       ServerManager.getInstance().getHttpPort();
                    String version =
                            ServerConfiguration.getInstance().getFirstProperty("Version");
                    outputStream.write(("<html><head>" +
                                        "<title>WSO2 Web Services Application Server v" +
                                        version +
                                        "Management Console" +
                                        " - " +
                                        axisService.getName() +
                                        " Service Schema</title>" +
                                        "</head>" +
                                        "<body>" +
                                        "<b>Schemas for " +
                                        axisService.getName() +
                                        " service</b><br/><br/>").getBytes());
                    if (schemas.size() != 0) {
                        for (int i = 0; i < schemas.size(); i++) {
                            String st = "<a href=\"" + ipAddress +
                                        RequestProcessorUtil.getServiceContextPath(configCtx) + "/" +
                                        axisService.getName() + "?xsd&id=" + i +
                                        "&" + ServerConstants.HTTPConstants.ANNOTATION + "=true" + "\">Schema " + i +
                                        "</a><br/>";
                            outputStream.write(st.getBytes());
                        }
                    } else {
                        outputStream.write("<p>No schemas found</p>".getBytes());
                    }
                    outputStream.write("</body></html>".getBytes());
                }
            }
        } else {  // service is null
            response.setContentType("text/html");
            outputStream.write(("<h4>Service " +
                                serviceName +
                                " is not found. Cannot display Schema.</h4>").getBytes());
            outputStream.flush();
        }
    }

    private static void processSchema(XmlSchema schema, OutputStream outputStream,
                                      String contextRoot, HttpServletRequest request) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        schema.write(baos);
        RequestProcessorUtil.writeDocument(baos, outputStream, "annotated-xsd.xsl", contextRoot,
                                           isXSDAnnotated(request));
    }


    private static boolean isXSDAnnotated(HttpServletRequest request) {
        String param = request.getParameter(ServerConstants.HTTPConstants.ANNOTATION);
        if (param != null && param.length() != 0) {
            if (param.equals("true")) {
                return true;
            }
        }
        return false;
    }
}
