/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.transport.util;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.wso2.utils.NetworkUtils;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.ServerManager;
import org.wso2.wsas.transport.HttpGetRequestProcessor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.ArrayList;

/**
 *
 */
public class PolicyProcessor implements HttpGetRequestProcessor {

    public void process(HttpServletRequest request,
                        HttpServletResponse response,
                        ConfigurationContext configCtx) throws Exception {
        String requestURI = request.getRequestURI();
        String contextPath = configCtx.getServiceContextPath();
        String serviceName = requestURI.substring(requestURI.indexOf(contextPath) + contextPath.length() + 1);
        AxisService axisService =
                configCtx.getAxisConfiguration().getServiceForActivation(serviceName);
        OutputStream outputStream = response.getOutputStream();

        if (axisService != null) {
            if (!axisService.isActive()) {
                response.setContentType("text/html");
                outputStream.write(("<h4>Service " +
                                    serviceName +
                                    " is inactive. Cannot display policies.</h4>").getBytes());
                outputStream.flush();
            } else {
                PolicyInclude policyInclude = axisService.getPolicyInclude();
                if (policyInclude == null) {
                    response.setContentType("text/html");
                    outputStream.write("<h4>Policy element is not found!</h4>".getBytes());
                    outputStream.flush();
                    return;

                }
                ArrayList policyElements = policyInclude.getPolicyElements();

                if (policyElements == null) {
                    response.setContentType("text/html");
                    outputStream.write("<h4>Policy elements not found!</h4>".getBytes());
                    outputStream.flush();
                    return;
                }

                PolicyRegistry reg = policyInclude.getPolicyRegistry();

                ExternalPolicySerializer serializer = new ExternalPolicySerializer();
                if (configCtx.getAxisConfiguration()
                        .getLocalPolicyAssertions() != null) {
                    serializer.setAssertionsToFilter(
                            configCtx.getAxisConfiguration().getLocalPolicyAssertions());
                }


                if (policyElements.size() == 1) {
                    response.setContentType("text/xml");
                    if (policyElements.get(0) instanceof Policy) {
                        Policy policy = (Policy) policyElements.get(0);
                        serializer.serialize(policy, outputStream);
                    } else if (policyElements.get(0) instanceof PolicyReference) {
                        String key = ((PolicyReference) policyElements.get(0)).getURI();
                        if (key.startsWith("#")) {
                            key = key.substring(key.indexOf("#") + 1);
                        }

                        Policy p = reg.lookup(key);
                        if (p == null) {
                            response.setContentType("text/html");
                            outputStream.write("<h4>Policy element not found!</h4>".getBytes());
                        } else {
                            serializer.serialize(p, outputStream);
                        }
                    }
                } else {
                    // for many policies
                    String idParam = request.getParameter("id");
                    if (idParam != null) {
                        Object policyObject = policyElements.get(Integer.parseInt(idParam));
                        if (policyObject != null) {
                            response.setContentType("text/xml");
                            if (policyObject instanceof Policy) {
                                Policy policy = (Policy) policyObject;
                                serializer.serialize(policy, outputStream);
                            } else if (policyObject instanceof PolicyReference) {
                                String key = ((PolicyReference) policyObject).getURI();
                                if (key.startsWith("#")) {
                                    key = key.substring(key.indexOf("#") + 1);
                                }
                                Policy p = reg.lookup(key);
                                if (p == null) {
                                    response.setContentType("text/html");
                                    outputStream
                                            .write("<h4>Policy element not found!</h4>".getBytes());
                                } else {
                                    serializer.serialize(p, outputStream);
                                }
                            }
                        } else {
                            response.setContentType("text/html");
                            outputStream.write("<h4>Policy not found!</h4>".getBytes());
                        }
                    } else {
                        if (policyElements.size() == 0) {
                            response.setContentType("text/html");
                            outputStream.write("<h4>Policy not found!</h4>".getBytes());
                        } else {
                            String ipAddress = "http://" + NetworkUtils.getLocalHostname() + ":" +
                                               ServerManager.getInstance().getHttpPort();
                            ServerConfiguration serverCofig = ServerConfiguration.getInstance();
                            outputStream.write(("<html><head>" +
                                                "<title>WSO2 Web Services Application Server v" +
                                                serverCofig.getFirstProperty("Version") +
                                                " Management Console - " +
                                                axisService.getName() +
                                                " Service Policies</title>" +
                                                "</head>" +
                                                "<body>" +
                                                "<b>Policies for " +
                                                axisService.getName() +
                                                " service</b><br/><br/>").getBytes());
                            if (policyElements.size() != 0) {
                                String serviceContextPath = RequestProcessorUtil.getServiceContextPath(configCtx);
                                for (int i = 0; i < policyElements.size(); i++) {
                                    String st = "<a href=\"" + ipAddress +
                                                serviceContextPath + "/" +
                                                axisService.getName() + "?policy&id=" + i +
                                                "\">Policy " + i +
                                                "</a><br/>";
                                    outputStream.write(st.getBytes());
                                }
                            } else {
                                outputStream.write("<h4>No policies found</h4>".getBytes());
                            }
                            outputStream.write("</body></html>".getBytes());
                        }

                    }
                }
            }
        } else { // Service is null
            response.setContentType("text/html");
            outputStream.write(("<h4>Service " + serviceName +
                                " not found. Cannot display policies.</h4>").getBytes());
            outputStream.flush();
        }
        outputStream.flush();
    }
}
