/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.transport.util;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.wsas.feed.FeedConstants;
import org.wso2.wsas.feed.FeedFactory;
import org.wso2.wsas.feed.atom.AtomFeed;
import org.wso2.wsas.transport.HttpGetRequestProcessor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

/**
 *
 */

public class AtomProcessor implements HttpGetRequestProcessor {
    private static Log log = LogFactory.getLog(AtomProcessor.class);

    public void process(HttpServletRequest request,
                        HttpServletResponse response,
                        ConfigurationContext configurationContext) throws Exception {
        try {
            response.setContentType("text/xml; charset=utf-8");
            AtomFeed atomFeed = FeedFactory.getAtomFeed(FeedConstants.WSO2WSAS_ATOM_FEED);
            if (atomFeed != null) {
                XMLStreamWriter writer =
                        XMLOutputFactory.newInstance().
                                createXMLStreamWriter(response.getOutputStream());
                writer.writeProcessingInstruction("xml-stylesheet",
                                                  "  type=\"text/xsl\" href=\"" +
                                                  (configurationContext.getContextRoot().equals("/") ?
                                                   "" : configurationContext.getContextRoot()) +
                                                                                               "/styles/atom.xsl\"");
                OMElement feedElement =
                        atomFeed.getFeedElement(configurationContext.getServiceContextPath());
                feedElement.serialize(writer);
                writer.flush();
            }
        } catch (Exception e) {
            log.error("Could not process ATOM feed", e);
        }
    }
}