/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.transport.http;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.Parameter;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Embedded;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.wso2.utils.transport.AbstractTransportListener;
import org.wso2.utils.transport.ProxyCache;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.ServerManager;
import org.wso2.wsas.TomcatServerCache;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;

/**
 *
 */
public class HttpsTransportListener extends AbstractTransportListener {
    private static Log log = LogFactory.getLog(HttpsTransportListener.class);
    private Connector connector;
    private boolean isStarted;

    public EndpointReference getEPRForService(String serviceName,
                                              String ip) throws AxisFault {
        return getEPR(ServerConstants.HTTPS_TRANSPORT, serviceName, ip);
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        return new EndpointReference[]{getEPRForService(serviceName, ip)};
    }

    public synchronized void start() throws AxisFault {
        if (isStarted) {
            return;
        }
        ServerManager.getInstance().setHttpsPort(port);
        /*

        This method processes the following block in the axis2.xml

        <parameter name="port" locked="false">9443</parameter>
        <parameter name="maxHttpHeaderSize" locked="false">8192</parameter>
        <parameter name="maxThreads" locked="false">150</parameter>
        <parameter name="minSpareThreads" locked="false">25</parameter>
        <parameter name="maxSpareThreads" locked="false">75</parameter>
        <parameter name="enableLookups" locked="false">false</parameter>
        <parameter name="disableUploadTimeout" locked="false">false</parameter>
        <parameter name="clientAuth" locked="false">false</parameter>
        <parameter name="acceptCount" locked="false">100</parameter>
        <parameter name="keystore" locked="false">
            <wso2wsas:KeyStore xmlns:wso2wsas="http://www.wso2.org/products/wsas">
                <!-- Key store file location-->
                <wso2wsas:Location>conf/wso2wsas.jks</wso2wsas:Location>
                <!-- Key store type (JKS/PKCS12 etc.)-->
                <wso2wsas:Type>JKS</wso2wsas:Type>
                <!-- Key store password-->
                <wso2wsas:Password>wso2wsas</wso2wsas:Password>
            </wso2wsas:KeyStore>
        </parameter>
        */

        Embedded embedded = TomcatServerCache.getEmbedded();

        try {
            if (connector == null) {
                connector =
                        embedded.createConnector((InetAddress) null, port, true);
                connector.setScheme(ServerConstants.HTTPS_TRANSPORT);
                ArrayList parameters = tInDescription.getParameters();
                for (Iterator iterator = parameters.iterator(); iterator.hasNext();) {
                    Parameter parameter = (Parameter) iterator.next();
                    String name = parameter.getName();
                    if (!name.equals("keystore")) {
                        connector.setAttribute(name, parameter.getValue());
                    }
                }

                {
                    OMElement ksEle =
                            tInDescription.getParameter("keystore").getParameterElement().getFirstElement();
                    String ksLocation =
                            ksEle.getFirstChildWithName(ServerConstants.Security.LOCATION).getText();
                    String absKsLocation;
                    if (!new File(ksLocation).isAbsolute()) {
                        absKsLocation =
                                new File(System.getProperty(ServerConstants.WSO2WSAS_HOME) + File.separator +
                                         ksLocation).getAbsolutePath();
                    } else {
                        absKsLocation = ksLocation;
                    }
                    String ksPassword =
                            ksEle.getFirstChildWithName(ServerConstants.Security.PASSWORD).getText();
                    IntrospectionUtils.setProperty(connector, "keypass", ksPassword);
                    IntrospectionUtils.setProperty(connector, "keystore", absKsLocation);
                }

                connector.setEnableLookups(true);
                connector.setSecure(true);
                TomcatServerCache.addConnector(connector);
                ProxyCache.getInstance().setHttpsPort(proxyPort);
            }
            connector.start();
            isStarted = true;
        } catch (Exception e) {
            embedded.removeConnector(connector);
            String msg = "Exception occurred while starting the Tomcat SSL connector";
            log.error(msg, e);
            throw new AxisFault(msg, e);
        }

        // Persist the SSL Key Store
        /*if (!KeyStoreUtil.keyStoreExists(ksLocation)) {
            try {
                KeyStoreUtil.persistKeyStore(ksLocation,
                                             ksPassword,
                                             ksType,
                                             "wso2wsas",
                                             ksPassword,
                                             null,
                                             true);
            } catch (KeyStoreAlreadyExistsException e) {
                log.error("", e);
                throw AxisFault.makeFault(e);
            } catch (ServerException e) {
                log.error("", e);
                throw AxisFault.makeFault(e);
            }
        }*/
    }

    public synchronized void stop() throws AxisFault {
        if (!isStarted) {
            return;
        }
        log.info("Stopping HTTPS transport...");
        try {
            if (connector.isAvailable()) {
                connector.stop();
            }
            isStarted = false;
        } catch (LifecycleException e) {
            String msg = "Cannot stop Tomcat HTTP connector";
            log.error(msg, e);
            throw new AxisFault(msg, e);
        }
    }
}
