/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.transport.http;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.Parameter;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Embedded;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.transport.AbstractTransportListener;
import org.wso2.utils.transport.ProxyCache;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.TomcatServerCache;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;

/**
 *
 */
public class HttpTransportListener extends AbstractTransportListener {
    private static Log log = LogFactory.getLog(HttpTransportListener.class);
    private boolean isStarted;
    private Connector connector;

    public EndpointReference getEPRForService(String serviceName,
                                              String ip) throws AxisFault {
        return getEPR(ServerConstants.HTTP_TRANSPORT, serviceName, ip);
    }

    public EndpointReference[] getEPRsForService(String serviceName,
                                                 String ip) throws AxisFault {
        return new EndpointReference[]{getEPRForService(serviceName, ip)};
    }

    public synchronized void start() throws AxisFault {
        if (isStarted) {
            return;
        }
        Embedded embedded = TomcatServerCache.getEmbedded();
        try {
            if (connector == null) {
                connector =
                        embedded.createConnector((InetAddress) null, port, false);
                connector.setEnableLookups(true);
                ArrayList parameters = tInDescription.getParameters();
                for (Iterator iterator = parameters.iterator(); iterator.hasNext();) {
                    Parameter parameter = (Parameter) iterator.next();
                    connector.setAttribute(parameter.getName(), parameter.getValue());
                }
                TomcatServerCache.addConnector(connector);
                ProxyCache.getInstance().setHttpPort(proxyPort);
            }
            connector.start();
            isStarted = true;
        } catch (Exception e) {
            embedded.removeConnector(connector);
            String msg = "Exception occurred while starting the Tomcat HTTP connector";
            log.error(msg, e);
            throw new AxisFault(msg, e);
        }
    }

    public synchronized void stop() throws AxisFault {
        if (!isStarted) {
            return;
        }
        log.info("Stopping HTTP transport...");
        try {
            if (connector.isAvailable()) {
                connector.stop();
            }
            isStarted = false;

//            ((Http11Protocol)connector.getProtocolHandler()).cHandler;
        } catch (LifecycleException e) {
            String msg = "Cannot stop Tomcat HTTP connector";
            log.error(msg, e);
            throw new AxisFault(msg, e);
        }
    }
}
