/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.transport.http;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.wso2.utils.WSO2Constants;
import org.wso2.utils.transport.ProxyCache;
import org.wso2.utils.transport.http.GenericHttpsTransportListener;
import org.wso2.wsas.ServerManager;

/**
 *
 */
public class GenericHttpTransportListener extends AbstractGenericTransportListener {


    public GenericHttpTransportListener() {
        super();
    }

    public GenericHttpTransportListener(ConfigurationContext configurationContext) {
        super(configurationContext);
    }

    public void start() throws AxisFault {
        ProxyCache.getInstance().setHttpPort(proxyPort);
    }

    public void init(ConfigurationContext configurationContext, TransportInDescription transportIn)
            throws AxisFault {
        this.configurationContext = configurationContext;
        Parameter portParam = transportIn.getParameter("port");
        if (portParam != null) {
            ServerManager.getInstance().
                    setHttpPort(Integer.parseInt(portParam.getValue().toString().trim()));
        }
        Parameter proxyPortParam = transportIn.getParameter(WSO2Constants.PROXY_PORT);
        if (proxyPortParam != null) {
            proxyPort = Integer.parseInt(proxyPortParam.getValue().toString());
        }

    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        if (configurationContext == null) {
            return null;
        }
        String serviceContextPath = configurationContext.getServiceContextPath();
        if (serviceContextPath == null) {
            throw new AxisFault(GenericHttpsTransportListener.class.getName() +
                                " Service Context path cannot be null");
        }
        return genEpr("http", ip, ServerManager.getInstance().getHttpPort(), serviceContextPath,
                      serviceName);
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        return new EndpointReference[]{getEPRForService(serviceName, ip)};
    }
}
