/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.transport.fileupload;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerException;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.util.WsasUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
/*
 * 
 */

public class SpringFileUploadExecutor extends AbstractFileUploadExecutor {

    public SpringFileUploadExecutor(ConfigurationContext configurationContext) {
        super(configurationContext);
    }

    public boolean execute(HttpServletRequest request, HttpServletResponse response)
            throws ServerException, IOException {

        PrintWriter out = response.getWriter();
        String axis2Repo = ServerConfiguration.getInstance().
                getFirstProperty(ServerConfiguration.AXIS2_CONFIG_REPO_LOCATION);
        if (WsasUtils.isURL(axis2Repo)) {
            out.write("<script language=\"javascript\">" +
                      "top.wso2.wsf.Util.alertWarning('You are not permitted to upload services to URL repository " +
                      axis2Repo + "');" +
                      "</script>");
            out.flush();
            return false;
        }
        response.setContentType("text/html; charset=utf-8");

        String[] uuids = new String[2];


        Map fileResourceMap = (Map) configurationContext.getProperty(
                ServerConstants.FILE_RESOURCE_MAP);
        if (fileResourceMap == null) {
            fileResourceMap = new TreeBidiMap();
            configurationContext.setProperty(ServerConstants.FILE_RESOURCE_MAP, fileResourceMap);
        }
        ServletRequestContext servletRequestContext = new ServletRequestContext(request);
        boolean isMultipart =
                ServletFileUpload.isMultipartContent(servletRequestContext);
        if (isMultipart) {
            try {
                // Create a new file upload handler
                List items = parseRequest(servletRequestContext);

                // Process the uploaded items
                for (Iterator iter = items.iterator(); iter.hasNext();) {
                    FileItem item = (FileItem) iter.next();
                    if (!item.isFormField()) {
                        String fileName = item.getName();
                        String fileExtension = fileName;
                        fileExtension = fileExtension.toLowerCase();

                        String fieldName = item.getFieldName();

                        String fileNameOnly = getFileName(fileName);
                        File uploadedFile;
                        File servicesDir;

                        if (fieldName.trim().equals("springBeans")) {
                            String uuid =
                                    String.valueOf(System.currentTimeMillis() + Math.random());
                            String serviceUploadDir = configurationContext
                                    .getProperty(ServerConstants.WORK_DIR) +
                                                                           File.separator + "spring" +
                                                                           File.separator + uuid +
                                                                           File.separator;
                            if (fileExtension.endsWith(".jar")) {

                                servicesDir = new File(serviceUploadDir);
                                servicesDir.mkdirs();
                                uploadedFile = new File(servicesDir, fileNameOnly);

                                uuids[0] = uuid;
                                fileResourceMap.put(uuid, uploadedFile.getAbsolutePath());
                                item.write(uploadedFile);
                            }

                        }
                        if (fieldName.trim().equals("springContext")) {
                            String uuid =
                                    String.valueOf(System.currentTimeMillis() + Math.random());
                            String serviceUploadDir = configurationContext
                                    .getProperty(ServerConstants.WORK_DIR) +
                                                                           File.separator + "spring" +
                                                                           File.separator + uuid +
                                                                           File.separator;
                            //Assumed this is the springs applicationContext.xml
                            // This can be safely assumed as, this class has been written only for
                            // uploading this.
                            servicesDir = new File(serviceUploadDir);
                            servicesDir.mkdirs();
                            uploadedFile = new File(servicesDir, fileNameOnly);

                            uuids[1] = uuid;
                            fileResourceMap.put(uuid, uploadedFile.getAbsolutePath());
                            item.write(uploadedFile);

                        }
                    }
                }

                // call the javascript which will in turn call the relevant web service
                out.write("<script language=\"javascript\">" +
                          "top.getSpringBeansFromArchive('" + uuids[0] + "','" + uuids[1] +
                          "');" +
                          "</script>");

                return true;

            } catch (Exception e) {
                log.error("File upload failed", e);
                out.write("<script language=\"javascript\">" +
                          "top.wso2.wsf.Util.alertWarning('Service file upload FAILED. " +
                          e.getMessage() + "');" +
                          "</script>");
            }
        }

        return false;
    }

}


