/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.transport.fileupload;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.engine.AxisConfiguration;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.ServerException;
import org.wso2.wsas.util.WsasUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
/*
 * 
 */

public class ModuleFileUploadExecutor extends AbstractFileUploadExecutor {

    public ModuleFileUploadExecutor(ConfigurationContext configurationContext) {
        super(configurationContext);
    }

    public boolean execute(HttpServletRequest request,
                           HttpServletResponse response) throws ServerException, IOException {
        String axis2Repo = ServerConfiguration.getInstance().
                getFirstProperty(ServerConfiguration.AXIS2_CONFIG_REPO_LOCATION);
        PrintWriter out = response.getWriter();
        if (WsasUtils.isURL(axis2Repo)) {
            out.write("<script language=\"javascript\">" +
                      "top.wso2.wsf.Util.alertWarning('You are not permitted to upload modules to URL repository " +
                      axis2Repo + "');" +
                      "</script>");
            out.flush();
            return false;
        }
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        String repo = axisConfiguration.getRepository().getPath();
        if (repo == null) {
            throw new ServerException("no repository found to deploy the service");
        }
        File moduledir = new File(repo, "modules");
        if (!moduledir.exists()) {
            moduledir.mkdir();
        }
        File uploadedFile = uploadFile(request, moduledir.getAbsolutePath(), response, ".mar");
        if (uploadedFile != null) {
            try {
                AxisModule axisModule =
                        DeploymentEngine.buildModule(uploadedFile, axisConfiguration);
                axisConfiguration.addModule(axisModule);
                out.write("<script language=\"javascript\">" +
                          "top.listModules();" +
                          "var restart= confirm(\"Module was uploaded successfuly to the repository.\" +\n" +
                          "                        \"\\n The server needs to be restarted for this to take effect.\" +\n" +
                          "                        \"\\n Restart now?\");\n" +
                          "if (restart) {\n" +
                          "   top.stopWaitAnimation()   ;\n" +
                          "   top.wso2.wsf.Util.restartServer();\n" +
                          "}" +
                          "</script>");
            } catch (Exception e) {
                out.write("<script language=\"javascript\">" +
                          "top.wso2.wsf.Util.alertWarning('Exception occurred during module upload. Reason : " +
                          e + "');" +
                          "top.listModules();" +
                          "</script>");
            }
            out.flush();
        }

        return true;
    }
}
