/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.transport;

import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.ServerManager;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
/*
 * 
 */

public class RequestRedirectionFilter implements Filter {

    private String contextRoot;

    /**
     * This init method will be invoked at MainServlet. This will be called at the startup time as
     * well as when the system is re-starting.
     *
     * @param filterConfig
     * @throws ServletException
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        filterConfig.getServletContext().setAttribute(this.getClass().getName(), this);
    }

    public void doFilter(ServletRequest request, ServletResponse response,
                         FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest) request;
        HttpServletResponse httpServletResponse = (HttpServletResponse) response;

        initContextRoot(httpServletRequest);

        if (httpServletRequest.getRequestURL().toString()
                .indexOf(NetworkUtils.getLocalHostname()) == -1) {
            httpServletResponse.sendRedirect("https://" +
                                             NetworkUtils.getLocalHostname() + ":" +
                                             ServerManager.getInstance().getHttpsPort() +
                                             (contextRoot.equals("/") ? contextRoot : contextRoot + "/")); // set the redirection
        } else {
            filterChain.doFilter(request, response);
        }

    }

    private void initContextRoot(HttpServletRequest request) {

        if (contextRoot != null && contextRoot.length() != 0) {
            return;
        }

        String contextRoot = request.getContextPath();
        if (contextRoot != null && contextRoot.length() == 0) {
            contextRoot = "/";
        }
        this.contextRoot = contextRoot;
    }

    public void destroy() {
        // TODO
    }
}
