/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.transport;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.AxisServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerException;
import org.wso2.wsas.ServerManager;
import org.wso2.wsas.util.FileDownloadUtil;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class FileDownloadServlet extends AxisServlet {
    private static final Log log = LogFactory.getLog(FileDownloadServlet.class);

    private static final long serialVersionUID = 6074514253507510250L;

    private FileDownloadUtil fileDownloadUtil;

    protected void doPost(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {
        res.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {
        MessageContext msgCtx = null;
        try {
            msgCtx = createMessageContext(req, res);
            fileDownloadUtil.acquireResource(configContext, req, res);
        } catch (ServerException e) {
            String msg = "Cannot download file";
            log.error(msg, e);
            if (msgCtx != null) {
                res.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
                handleFault(msgCtx, res.getOutputStream(), AxisFault.makeFault(e));
            } else {
                throw new ServletException(e);
            }
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        ServletContext servletContext = servletConfig.getServletContext();
        this.configContext =
                (ConfigurationContext) servletContext.getAttribute(CONFIGURATION_CONTEXT);
        if (this.configContext == null) {
            this.configContext = ServerManager.getInstance().configContext;
        }
        this.axisConfiguration = this.configContext.getAxisConfiguration();
        fileDownloadUtil = new FileDownloadUtil();
        servletContext.setAttribute(this.getClass().getName(), this);
        this.servletConfig = servletConfig;
        initParams();
    }


}
