/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.serverinfo;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerConfiguration;
import org.wso2.wsas.transport.ServerPropertyKeys;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import java.io.FileReader;
import java.util.Iterator;
import java.util.Properties;

public class Tomcat5xServerInfo implements ServerInfo {
    private int httpPort = 8080;
    private int httpsPort = 8443;
    private Properties props;
    private static Log log = LogFactory.getLog(Tomcat5xServerInfo.class);

    public void setProperties(Properties props) {
        this.props = props;
    }

    public Tomcat5xServerInfo() {
    }

    public void process() {
        String serverXML =
                props.getProperty(ServerPropertyKeys.TOMCAT_SERVER_XML);
        try {
            XMLStreamReader parser =
                    XMLInputFactory.newInstance().
                            createXMLStreamReader(new FileReader(serverXML));
            OMXMLParserWrapper builder =
                    OMXMLBuilderFactory.createStAXOMBuilder(OMAbstractFactory.getOMFactory(),
                                                            parser);
            OMElement docEle = builder.getDocumentElement();
            OMElement serviceEle =
                    docEle.getFirstChildWithName(new QName("Service"));

            /*
              if(sslProtocol attribute is not null){
                 this is an https port
              } else if(protocol attrib is null && ){
                   this is an http 1.1 port
              }
            */
            String keystoreFile = "";
            String keystorePass = "";
            for (Iterator iter = serviceEle.getChildrenWithName(new QName("Connector"));
                 iter.hasNext();) {

                OMElement omEle = (OMElement) iter.next();
                OMAttribute sslProtocolAttr = omEle.getAttribute(new QName("sslProtocol"));
                if (sslProtocolAttr != null) { // This is an HTTPS connector
                    httpsPort =
                            Integer.parseInt(omEle.getAttribute(new QName("port")).
                                    getAttributeValue());
                    keystoreFile
                            = omEle.getAttribute(new QName("keystoreFile")).getAttributeValue();
                    keystorePass
                            = omEle.getAttribute(new QName("keystorePass")).getAttributeValue();
                    continue;
                }
                OMAttribute protocolAttr = omEle.getAttribute(new QName("protocol"));
                if (protocolAttr == null) { // This is the first HTTP connector found
                    httpPort =
                            Integer.parseInt(omEle.getAttribute(new QName("port")).
                                    getAttributeValue());
                }
            }

            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            serverConfig.setConfigurationProperty("HTTPS.keyStore.Type", "JKS");
//            serverConfig.setConfigurationProperty("HTTPS.keyStore.KeyAlias", "wso2wsas");

            serverConfig.setConfigurationProperty("HTTPS.keyStore.Location", keystoreFile);
            serverConfig.setConfigurationProperty("HTTPS.keyStore.Password", keystorePass);
            serverConfig.setConfigurationProperty("HTTPS.keyStore.KeyPassword", keystorePass);
        } catch (Exception e) {
            e.printStackTrace();
            String msg = "Cannot read HTTP and HTTPS ports from Tomcat server.xml";
            log.error(msg, e);
            throw new RuntimeException(msg, e);
        }
    }

    public int getHttpPort() {
        return httpPort;
    }

    public int getHttpsPort() {
        return httpsPort;
    }
}
