/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.serverinfo;

import java.util.Properties;

/**
 * Interface used by WSO2 WSAS to interact/interface with the container in which
 * a given WSO2 WSAS instance is deployed in.
 */
public interface ServerInfo {

    /**
     * Return the http port of the container through which the WSO2 WSAS services
     * are accessible.
     *
     * @return The HTTP port
     */
    int getHttpPort();

    /**
     * Return the https port of the container through which WSO2 WSAS
     * services are accessible.
     *
     * @return The HTTPS port
     */
    int getHttpsPort();

    /**
     * Load and set the properties from the container.
     * This properties can be used to supply information such as the location of
     * server.xml from the specific container so that later on the
     * <code>process()</code> method can process those properties and compute
     * the WSO2 WSAS configurations.
     *
     * @param props
     * @see ServerInfo#process()
     */
    void setProperties(Properties props);

    /**
     * Process the server configuration to populate the properties that are
     * relevant to WSO2 WSAS
     */
    void process();

}
