/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.serverinfo;

import org.apache.catalina.connector.Connector;
import org.wso2.wsas.ServerConstants;
import org.wso2.wsas.TomcatServerCache;

import java.util.Properties;

/**
 *
 */
public class EmbeddedTomcatServerInfo implements ServerInfo {

    private int httpPort = -1;
    private int httpsPort = -1;

    /**
     * Return the http port of the container through which the WSO2 WSAS services
     * are accessible.
     *
     * @return The HTTP port
     */
    public int getHttpPort() {
        return httpPort;
    }

    /**
     * Return the https port of the container through which WSO2 WSAS
     * services are accessible.
     *
     * @return The HTTPS port
     */
    public int getHttpsPort() {
        return httpsPort;
    }

    /**
     * Load and set the properties from the container.
     * This properties can be used to supply information such as the location of
     * server.xml from the specific container so that later on the
     * <code>process()</code> method can process those properties and compute
     * the WSO2 WSAS configurations.
     *
     * @param props
     * @see ServerInfo#process()
     */
    public void setProperties(Properties props) {
        // Nothing to do here
    }

    /**
     * Process the server configuration to populate the properties that are
     * relevant to WSO2 WSAS
     */
    public void process() {
        Connector httpConnector = TomcatServerCache.getConnector(ServerConstants.HTTP_TRANSPORT);
        if (httpConnector != null) {
            this.httpPort = httpConnector.getPort();
        }
        Connector sslConnector = TomcatServerCache.getConnector(ServerConstants.HTTPS_TRANSPORT);
        if (sslConnector != null) {
            this.httpsPort = sslConnector.getPort();
        }
    }
}
