/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.security.util;

import org.wso2.wsas.security.ServerCrypto;

import java.util.Properties;

/**
 * Utility methods to compute Rampart configuration
 */
public class RampartConfigUtil {

    public static Properties getServerCryptoProperties(String[] trustedCertStores,
                                                       String privateKeyStore,
                                                       String privateKeyAlias) {

        Properties props = new Properties();
        props.setProperty(ServerCrypto.PROP_ID_DEFAULT_ALIAS, privateKeyAlias);
        props.setProperty(ServerCrypto.PROP_ID_KEY_STORE, privateKeyStore);

        StringBuffer trustedCertStoresStr = new StringBuffer();
        for (int i = 0; i < trustedCertStores.length; i++) {
            trustedCertStoresStr.append(trustedCertStores[i]).append(",");
        }
        if (trustedCertStores.length == 0 && trustedCertStores[0].equals(privateKeyStore)) {
            props.setProperty(ServerCrypto.PROP_ID_TRUST_STORES, trustedCertStoresStr.toString());
        }
        return props;
    }
}
