/*                                                                             
 * Copyright 2004,2005 The Apache Software Foundation.                         
 *                                                                             
 * Licensed under the Apache License, Version 2.0 (the "License");             
 * you may not use this file except in compliance with the License.            
 * You may obtain a copy of the License at                                     
 *                                                                             
 *      http://www.apache.org/licenses/LICENSE-2.0                             
 *                                                                             
 * Unless required by applicable law or agreed to in writing, software         
 * distributed under the License is distributed on an "AS IS" BASIS,           
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.    
 * See the License for the specific language governing permissions and         
 * limitations under the License.                                              
 */
package org.wso2.wsas.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.utils.ServerConfiguration;
import org.wso2.utils.security.CryptoException;
import org.wso2.utils.security.CryptoUtil;
import org.wso2.wsas.persistence.PersistenceManager;
import org.wso2.wsas.persistence.dataobject.ServiceUserDO;

import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import java.io.File;
import java.util.Collections;

/**
 * JMX Authenticator for WSAS
 */
public class WSASJMXAuthenticator implements JMXAuthenticator {

    private static Log log = LogFactory.getLog(WSASJMXAuthenticator.class);

    public Subject authenticate(Object credentials) {

        // Verify that credentials is of type String[].
        //
        if (!(credentials instanceof String[])) {
            // Special case for null so we get a more informative message
            if (credentials == null) {
                throw new SecurityException("Credentials required");
            }
            throw new SecurityException("Credentials should be String[]");
        }

        // Verify that the array contains username/password
        //
        final String[] aCredentials = (String[]) credentials;
        if (aCredentials.length < 2) {
            throw new SecurityException("Credentials should have at least username & password");
        }

        // Perform authentication
        //
        String username = aCredentials[0];
        String password = aCredentials[1];

        // perform authentication
        boolean authenticated = false;
        PersistenceManager pm = new PersistenceManager();
        ServiceUserDO user = pm.getUser(username);
        if (user != null) {
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            CryptoUtil cryptoUtil =
                    new CryptoUtil(new File(
                            serverConfig.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath(),
                                   serverConfig.getFirstProperty("Security.KeyStore.Password"),
                                   serverConfig.getFirstProperty("Security.KeyStore.KeyAlias"),
                                   serverConfig.getFirstProperty("Security.KeyStore.KeyPassword"),
                                   serverConfig.getFirstProperty("Security.KeyStore.Type"));
            try {
                String pwd = new String(cryptoUtil.base64DecodeAndDecrypt(user.getPassword()));
                if (pwd.equals(password)) {
                    authenticated = true;
                }
            } catch (CryptoException e) {
                String msg = "Could not decrypt password";
                log.error(msg, e);
                throw new SecurityException(msg, e);
            }
        }

        if (authenticated) {
            return new Subject(true,
                               Collections.singleton(new JMXPrincipal(username)),
                               Collections.EMPTY_SET,
                               Collections.EMPTY_SET);
        } else {
            throw new SecurityException("Username and/or password are incorrect, " +
                                        "or you do not have the necessary access rights.");
        }
    }
}
