/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

import java.util.HashSet;
import java.util.Set;

/**
 *
 */
public class TransportDO extends AbstractDataObject {

    private String transportProtocol;
    private boolean isStarted;
    private Set services = new HashSet(); // many-to-many relationship between services & transports
    private Set parameters = new HashSet(); // one-many relationship between Transports and TransportParametes

    public TransportDO() {
    }

    public String getTransportProtocol() {
        return transportProtocol;
    }

    public void setTransportProtocol(String transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    public boolean getIsStarted() {
        return isStarted;
    }

    public void setIsStarted(boolean started) {
        isStarted = started;
    }

    public Set getServices() {
        return services;
    }

    public void setServices(Set services) {
        this.services = services;
    }

    public Set getParameters() {
        return parameters;
    }

    public void setParameters(Set parameters) {
        this.parameters = parameters;
    }

    public void addParameter(TransportParameterDO transportParameter) {
        parameters.add(transportParameter);
        transportParameter.setTransport(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        return transportProtocol.equals(((TransportDO) o).transportProtocol);
    }

    public int hashCode() {
        return transportProtocol.hashCode();
    }
}
