/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

import java.util.HashSet;
import java.util.Set;

/**
 * Data object representing user roles in WSO2 WSAS
 */
public class ServiceUserRoleDO extends AbstractDataObject {
    private String role;
    private Set users = new HashSet(); // many-to-may relationship between roles & users
    private Set services = new HashSet(); // many-to-many relationship between roles & services

    private String description;

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceUserRoleDO() {
    }

    public ServiceUserRoleDO(String role) {
        this.role = role;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Set getUsers() {
        return users;
    }

    public void setUsers(Set users) {
        this.users = users;
    }

    public Set getServices() {
        return services;
    }

    public void setServices(Set services) {
        this.services = services;
    }

    public void addService(ServiceDO service) {
        services.add(service);
        service.getRoles().add(this);//TODO Inverse side
    }

    public void addUser(ServiceUserDO serviceUser) {
//        serviceUser.setServiceUserRole(this);
        serviceUser.getRoles().add(this);
        users.add(serviceUser);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServiceUserRoleDO) {
            return role.equals(((ServiceUserRoleDO) obj).getRole());
        }
        return false;
    }

    public int hashCode() {
        return role.hashCode();
    }
}
