/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * Data object representing a user of a service(s) in WSO2 WSAS
 */
public class ServiceUserDO extends AbstractDataObject {
    private String username;
    private String password;
    private Date lastLoggedIn;
    private String lastLoginIP;
    private String lastFailedLoginIP;
    private Date lastFailedLogIn;
    private Set services = new HashSet(); // many-many relationship between services & service users
    private Set roles = new HashSet(); // many-to-many relationship between users & roles.

    private String description;

    public int hashCode() {
        return username.hashCode();
    }

    public ServiceUserDO() {
    }

    public boolean equals(Object obj) {
        return obj instanceof ServiceUserDO &&
               username.trim().equals(((ServiceUserDO) obj).getUsername());
    }

    public boolean hasRole(String role) {
        return roles.contains(new ServiceUserRoleDO(role));
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set getRoles() {
        return roles;
    }

    public void setRoles(Set roles) {
        this.roles = roles;
    }

    public Set getServices() {
        return services;
    }

    public void setServices(Set services) {
        this.services = services;
    }

    public void addService(ServiceDO service) {
        service.getUsers().add(this);
        services.add(service);
    }

    public void removeService(ServiceDO service) {
        services.remove(service);
        service.getUsers().remove(this);
    }

    public void addRole(ServiceUserRoleDO role) {
        roles.add(role);
        role.getUsers().add(this);
    }

    public String toString() {
        return username;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getLastLoggedIn() {
        return lastLoggedIn;
    }

    public void setLastLoggedIn(Date lastLoggedIn) {
        this.lastLoggedIn = lastLoggedIn;
    }

    public Date getLastFailedLogIn() {
        return lastFailedLogIn;
    }

    public void setLastFailedLogIn(Date lastFailedLogIn) {
        this.lastFailedLogIn = lastFailedLogIn;
    }

    public String getLastLoginIP() {
        return lastLoginIP;
    }

    public void setLastLoginIP(String lastLoginIP) {
        this.lastLoginIP = lastLoginIP;
    }

    public String getLastFailedLoginIP() {
        return lastFailedLoginIP;
    }

    public void setLastFailedLoginIP(String lastFailedLoginIP) {
        this.lastFailedLoginIP = lastFailedLoginIP;
    }
}
