/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

/**
 * Data object representing a parameter of a service
 */
public class ServiceParameterDO extends AbstractDataObject {
    private String name;
    private String value;
    private ServiceDO service; // many-one relationship between ServiceParameters and Services

    public ServiceParameterDO() {
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ServiceDO getService() {
        return service;
    }

    public void setService(ServiceDO service) {
        this.service = service;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServiceParameterDO) {
            ServiceParameterDO paramDO = (ServiceParameterDO) obj;
            return paramDO.getName().equals(name) &&
                   service.equals(paramDO.getService());
        }
        return false;
    }

    public int hashCode() {
        return name.hashCode();
    }
}
