/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

/**
 * Data object representing a service identifier in WSO2 WSAS
 */
public class ServiceIdentifierDO {
    public static final String EMPTY_SERVICE_VERSION = "$EMPTY$";

    private String serviceId;
    private String version = EMPTY_SERVICE_VERSION;

    public ServiceIdentifierDO() {
    }

    public String getServiceId() {
        return serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int hashCode() {
        return (serviceId + version).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ServiceIdentifierDO) {
            ServiceIdentifierDO sid = (ServiceIdentifierDO) obj;
            return sid.getServiceId().equals(serviceId) && sid.getVersion().equals(version);
        }
        return false;
    }
}
