/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/**
 * Data object representing a service group in WSO2 WSAS
 */
public class ServiceGroupDO extends AbstractDataObject {
    private String name;
    private Long serviceArtifactUpdateTime;
    private Set services = new HashSet(); // many-one relationship between ServiceGroups & Services
    private Set parameters = new HashSet(); // many-one relationship between ServiceGroups & Parameters
    private Set engagedModules = new HashSet(); // many-many relationship between ServiceGroups and engaged modules

    public ServiceGroupDO() {
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getServiceArtifactUpdateTime() {
        return serviceArtifactUpdateTime;
    }

    public void setServiceArtifactUpdateTime(Long serviceArtifactUpdateTime) {
        this.serviceArtifactUpdateTime = serviceArtifactUpdateTime;
    }

    public Set getServices() {
        return services;
    }

    public void setServices(Set services) {
        this.services = services;
    }

    public Set getEngagedModules() {
        return engagedModules;
    }

    public void setEngagedModules(Set engagedModules) {
        this.engagedModules = engagedModules;
    }

    public Set getParameters() {
        return parameters;
    }

    public void setParameters(Set parameters) {
        this.parameters = parameters;
    }

    public void addService(ServiceDO service) {
        services.add(service);
        service.setServiceGroup(this);
    }

    public void addModule(ModuleDO module) {
        engagedModules.add(module);
        module.getEngagedServiceGroups().add(this);
    }

    public void addParameter(ServiceGroupParameterDO param) {
        param.setServiceGroup(this);
        parameters.add(param);
    }

    public ServiceGroupParameterDO getParameter(String paramName) {
        for (Iterator iterator = parameters.iterator(); iterator.hasNext();) {
            ServiceGroupParameterDO paramDO = (ServiceGroupParameterDO) iterator.next();
            if (paramDO.getName().equals(paramName)) {
                return paramDO;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final ServiceGroupDO that = (ServiceGroupDO) o;

        if (name != null ? !name.equals(that.name) : that.name != null) {
            return false;
        }

        return true;
    }

    public int hashCode() {
        return (name != null ? name.hashCode() : 0);
    }
}
