/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

/**
 *
 */
public class SecurityTokenPropertyDO extends AbstractDataObject {
    private String name;
    private String value;
    private SecurityTokenDO token;

    public SecurityTokenPropertyDO(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public SecurityTokenPropertyDO() {
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SecurityTokenDO getToken() {
        return token;
    }

    public void setToken(SecurityTokenDO token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final SecurityTokenPropertyDO that = (SecurityTokenPropertyDO) o;

        if (!name.equals(that.name)) {
            return false;
        }
        return token.equals(that.token);
    }

    public int hashCode() {
        int result;
        result = name.hashCode();
        if (token != null) {
            result = 29 * result + token.hashCode();
        }
        return result;
    }
}
