/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

import java.util.HashSet;
import java.util.Set;

/**
 *
 */
public class SecurityScenarioDO extends AbstractDataObject {
    public Set services = new HashSet(); // 1-m relationship between Security Scenarios & Services
    public Set modules = new HashSet(); // m-n relationship between Sec scenarios & modules

    private String scenarioId;
    private String summary;
    private String category;
    private String description;
    private boolean isCurrentScenario;

    /**
     * Constructs a new SecurityScenarioDO.
     */
    public SecurityScenarioDO() {
    }

    /**
     * Getter for property 'summary'.
     *
     * @return Value for property 'summary'.
     * @see #setSummary
     */
    public String getSummary() {
        return summary;
    }

    /**
     * Setter for property 'summary'.
     *
     * @param summary Value to set for property 'summary'.
     * @see #getSummary
     */
    public void setSummary(String summary) {
        this.summary = summary;
    }

    /**
     * Getter for property 'description'.
     *
     * @return Value for property 'description'.
     * @see #setDescription
     */
    public String getDescription() {
        return description;
    }

    /**
     * Setter for property 'description'.
     *
     * @param description Value to set for property 'description'.
     * @see #getDescription
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Getter for property 'scenarioId'.
     *
     * @return Value for property 'scenarioId'.
     * @see #setScenarioId
     */
    public String getScenarioId() {
        return scenarioId;
    }

    /**
     * Setter for property 'scenarioId'.
     *
     * @param scenarioId Value to set for property 'scenarioId'.
     * @see #getScenarioId
     */
    public void setScenarioId(String scenarioId) {
        this.scenarioId = scenarioId;
    }

    /**
     * Getter for property 'services'.
     *
     * @return Value for property 'services'.
     * @see #setServices
     */
    Set getServices() {
        return services;
    }

    /**
     * Setter for property 'services'.
     *
     * @param services Value to set for property 'services'.
     * @see #getServices
     */
    void setServices(Set services) {
        this.services = services;
    }

    Set getModules() {
        return modules;
    }

    void setModules(Set modules) {
        this.modules = modules;
    }

    public void addService(ServiceDO service) {
        services.add(service);
        service.setSecurityScenario(this);
    }

    public void removeService(ServiceDO service) {
        services.remove(service);
        if (service != null) {
            service.setSecurityScenario(null);
        }
    }

    public void addModule(ModuleDO module) {
        modules.add(module);
        module.getSecurityScenarios().add(this);
    }

    /**
     * Getter for property 'currentScenario'.
     *
     * @return Value for property 'currentScenario'.
     * @see #setIsCurrentScenario
     */
    public boolean getIsCurrentScenario() {
        return isCurrentScenario;
    }

    /**
     * Setter for property 'currentScenario'.
     *
     * @param currentScenario Value to set for property 'currentScenario'.
     * @see #isCurrentScenario
     */
    public void setIsCurrentScenario(boolean currentScenario) {
        isCurrentScenario = currentScenario;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}
