/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

import java.util.HashSet;
import java.util.Set;

/**
 * Data object representing an axis operation
 */
public class OperationDO extends AbstractDataObject {
    private ServiceDO service;
    private String name;
    private String documentation;
    private Set engagedModules = new HashSet();  // many-many relationship between operations & modules (Operation-Module Engagement)
    private Set parameters = new HashSet(); // one-many relationship between Operations and OperationParameters
    private Set messages = new HashSet(); // one-many relationship between Operations and Messages

    public OperationDO() {
    }

    public ServiceDO getService() {
        return service;
    }

    public void setService(ServiceDO service) {
        this.service = service;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set getEngagedModules() {
        return engagedModules;
    }

    public void setEngagedModules(Set engagedModules) {
        this.engagedModules = engagedModules;
    }

    public Set getParameters() {
        return parameters;
    }

    public void setParameters(Set parameters) {
        this.parameters = parameters;
    }

    public Set getMessages() {
        return messages;
    }

    public void setMessages(Set messages) {
        this.messages = messages;
    }

    public void addEngagedModule(ModuleDO module) {
        engagedModules.add(module);
        module.getEngagedOperations().add(this);
    }

    public void addParameter(OperationParameterDO param) {
        parameters.add(param);
        param.setOperation(this);
    }

    public void addMessage(MessageDO message) {
        messages.add(message);
        message.setOperationDO(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OperationDO) {
            OperationDO op = (OperationDO) obj;
            if (this.service != null &&
                this.service.equals(op.service) &&
                this.name.equals(op.name)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (service != null) {
            return service.hashCode() + name.hashCode();
        } else {
            return name.hashCode();
        }
    }

    public String getDocumentation() {
        return documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }
}
