/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.persistence.dataobject;

/**
 * Data object representing an Axis2 module which is the combination of the
 * module name and the module version.
 * <p>Example: foo-x.y.mar</p>
 * <ol>
 * <li>Module name - foo</li>
 * <li>Module version - x.y</li>
 * </ol>
 */
public class ModuleIdentifierDO {
    private String name;
    private String version;

    public ModuleIdentifierDO() {
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final ModuleIdentifierDO that = (ModuleIdentifierDO) o;

        if (!name.equals(that.name)) {
            return false;
        }
        return version.equals(that.version);
    }

    public int hashCode() {
        int result;
        result = name.hashCode();
        result = 29 * result + version.hashCode();
        return result;
    }
}
